package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSRequest;
import com.cogniance.acs.messaging.params.ParameterValueStruct;
import com.cogniance.acs.messaging.util.DataType;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * Used to set values of a list of parameters.
 */
public class SetParameterValues extends AbstractMessage implements ACSRequest {
    private ArrayList<ParameterValueStruct> parameterList;
    private String parameterKey;

    public SetParameterValues() {
        super("SetParameterValues");
        this.parameterList = new ArrayList<ParameterValueStruct>();
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        SOAPElement paramList = body.addChildElement(SOAP_FACTORY.createName("ParameterList"));
        paramList.setAttribute(AbstractMessage.SOAP_ENC + ":arrayType", "cwmp:ParameterValueStruct[" + parameterList.size() + "]");
        for (ParameterValueStruct pvs : this.parameterList) {
            SOAPElement parameter = paramList.addChildElement("ParameterValueStruct");
            parameter.addChildElement("Name").setValue(pvs.getName());
            SOAPElement value = parameter.addChildElement("Value");
            value.setValue(pvs.getValue());
            value.setAttribute("xsi:type", pvs.getType());
        }
        body.addChildElement(SOAP_FACTORY.createName("ParameterKey")).setValue(String.valueOf(this.parameterKey));
    }

    public <T> SetParameterValues addParameter(String name, DataType<T> type, T value) {
        addParameter(new ParameterValueStruct(name, type.getValueType(), type.format(value)));
        return this;
    }

    public SetParameterValues addParameter(ParameterValueStruct pvs) {
        if (!parameterList.contains(pvs))
            this.parameterList.add(pvs);
        return this;
    }

    public ArrayList<ParameterValueStruct> getParameterList() {
        return parameterList;
    }

    public void setParameterKey(String parameterKey) {
        this.parameterKey = parameterKey;
    }

    public String getParameterKey() {
        return this.parameterKey;
    }
}
