package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSRequest;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

import static com.cogniance.acs.messaging.util.DataTypes.formatBoolean;

/**
 * Used to get the names of parameters.
 */
public class GetParameterNames extends AbstractMessage implements ACSRequest {
	private String parameterPath;
    private NextLevelMode nextLevelMode;

    public GetParameterNames() {
		super("GetParameterNames");
	}

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        body.addChildElement(SOAP_FACTORY.createName("ParameterPath")).setValue(this.parameterPath);
        SOAPElement nextLevelElement = body.addChildElement(SOAP_FACTORY.createName("NextLevel"));
        nextLevelElement.setValue(formatBoolean(nextLevelMode.toBoolean()));
    }

	public String getParameterPath() {
		return parameterPath;
	}

	public void setParameterPath(String parameterPath) {
		this.parameterPath = parameterPath;
	}

	public NextLevelMode getNextLevelMode() {
		return nextLevelMode;
	}

	public void setNextLevelMode(NextLevelMode nextLevelMode) {
        this.nextLevelMode = nextLevelMode;
	}

    public enum NextLevelMode {
        ONLY_NEXT_LEVEL(true),
        RECURSIVELY(false);

        private final boolean onlyNextLevel;

        private NextLevelMode(boolean onlyNextLevel) {
            this.onlyNextLevel = onlyNextLevel;
        }

        private boolean toBoolean() {
            return onlyNextLevel;
        }
    }
}
