package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.CPEResponse;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElementValue;

/**
 * How the download went.
 */
public class DownloadResponse extends AbstractMessage implements CPEResponse {
    private ResponseStatus status;
    private String startTime;
    private String completeTime;

    public DownloadResponse() {
        super("DownloadResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.status = ResponseStatus.byCode(Integer.parseInt(getChildElementValue(body, "Status")));
        this.startTime = getChildElementValue(body, "StartTime");
        this.completeTime = getChildElementValue(body, "CompleteTime");
    }

    public ResponseStatus getStatus() {
        return status;
    }

    public String getStartTime() {
        return startTime;
    }

    public String getCompleteTime() {
        return completeTime;
    }

    public enum ResponseStatus {
        /**
         * Download has been completed and applied.
         */
        DOWNLOADED_AND_APPLIED(0),
        /*
         * Download has been completed but not applied, yet.
         */
        DOWNLOADED_AND_AWAITING(1);

        private int code;

        ResponseStatus(int code) {
            this.code = code;
        }

        public int getCode() {
            return code;
        }

        static public ResponseStatus byCode(int code) {
            for (ResponseStatus status : values()) {
                if (status.getCode() == code) {
                    return status;
                }
            }
            throw new IllegalArgumentException("Passed code was not found.");
        }
    }
}
