package com.cogniance.acs;

import com.cogniance.acs.util.Utils;

public class Command {

	private String cmd;
	private String name;
	private String type;
	private String value;
	
	public Command(String cmd, String name, String type, String value) {
		this.cmd = cmd;
		this.name = name;
		this.type = type;
		this.value = value;
	}

	public String getCmd() {
		return cmd;
	}

	public void setCmd(String cmd) {
		this.cmd = cmd;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public boolean isValid() {
		if (Utils.isBlank(cmd)) {
			System.out.println("1");
			return false;
		}

		if (!cmd.equals("get") && !cmd.equals("set")) {
			System.out.println("2");
			return false;
		}

		if (Utils.isBlank(name)) {
			System.out.println("3");
			return false;
		}

		if (cmd.equals("set")) {
			if (Utils.isBlank(type)) {
				System.out.println("4");
				return false;
			}

			if (Utils.isBlank(value)) {
				System.out.println("5");
				return false;
			}
		}

		return true;
	}

	@Override
	public String toString() {
		return "Command [cmd=" + cmd + ", name=" + name + ", type=" + type + ", value=" + value + "]";
	}
	
	

}
