package com.cogniance.acs;

import java.util.List;

import com.cogniance.acs.util.Utils;

public class Combo {

	private String name;
	private List<Command> commands;
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public List<Command> getCommands() {
		return commands;
	}
	
	public void setCommands(List<Command> commands) {
		this.commands = commands;
	}
	
	public boolean isValid() {
		if (Utils.isBlank(name)) {
			return false;
		}
		
		if (commands == null || commands.isEmpty()) {
			return false;
		}
		
		for (Command command : commands) {
			if (!command.isValid()) {
				System.out.println("Command invalid: " + command);
				return false;
			}
		}
		
		return true;
	}
}
