package com.cogniance.acs.server.api;

import com.cogniance.acs.messaging.Inform;
import com.cogniance.acs.messaging.api.Message;
import com.cogniance.acs.messaging.api.helping.ACSMessage;
import com.cogniance.acs.messaging.api.helping.CPEMessage;

import java.util.List;
import java.util.concurrent.TimeUnit;

public interface Session {

    Inform getInform();

    Message getLastMessage();

    List<Message> getMessages();

    void completeSession() throws InterruptedException;

    <T extends CPEMessage> T awaitCPEMessage(long timeout, TimeUnit timeUnit) throws InterruptedException, AwaitTimeoutException;

    void sendACSMessage(ACSMessage acsMessage);

    boolean isFinished();

    boolean isCPEFinishedRequests();
}
