package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSResponse;
import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.util.soap.SOAPUtils;
import com.google.common.collect.Lists;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElement;

/**
 * Response with a list of the supported methods.
 */
public class GetRPCMethodsResponse extends AbstractMessage implements CPEResponse, ACSResponse {
    private final ArrayList<String> methodList = new ArrayList<String>();

    public GetRPCMethodsResponse() {
        super("GetRPCMethodsResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.methodList.clear();

        SOAPElement methodListElement = getChildElement(body, "MethodList");
        Iterator iterator = methodListElement.getChildElements(SOAP_FACTORY.createName("string"));
        while (iterator.hasNext()) {
            this.methodList.add(((SOAPElement) iterator.next()).getValue());
        }
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        SOAPElement mList = body.addChildElement(SOAP_FACTORY.createName("MethodList"));
        mList.setAttribute("SOAP-ENC:arrayType", "xsd:string[" + methodList.size() + "]");
        for (String methodName : methodList) {
            mList.addChildElement("string").setValue(methodName);
        }
    }

    public void setMethodList(List<String> methods) {
        methodList.clear();
        methodList.addAll(methods);
    }

    public List<String> getMethodList() {
        return methodList;
    }
}
