package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSRequest;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import java.util.ArrayList;
import java.util.List;

/**
 * This method can be used to obtain parameter values of the CPE.
 *
 */
public class GetParameterValues extends AbstractMessage implements ACSRequest {
	private final List<String> parameterNames = new ArrayList<String>();

	public GetParameterValues() {
		super("GetParameterValues");
	}

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        SOAPElement pNames = body.addChildElement(SOAP_FACTORY.createName("ParameterNames"));
        pNames.setAttribute(AbstractMessage.SOAP_ENC+":arrayType", "xsd:string["+parameterNames.size()+"]");

        for (String name : this.parameterNames) {
            pNames.addChildElement("string").setValue(name);
        }
    }

	public void addParameter(String parameter) {
		if(!this.parameterNames.contains(parameter))
			this.parameterNames.add(parameter);
	}

	public List<String> getParameterNames() {
		return parameterNames;
	}
}
