package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSRequest;

import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;

import static com.google.common.base.Objects.firstNonNull;

/**
 * Used to cause a CPE to download a file.
 */
public class Download extends AbstractMessage implements ACSRequest {

    public static final String FILE_TYPE_FIRMWARE_IMAGE = "1 Firmware Upgrade Image";

    private String commandKey = "";
    private String fileType = "";
    private String url = "";
    private String username = "";
    private String password = "";
    private Integer fileSize = 0;
    private String targetFileName = "";
    private Integer delaySeconds = 0;
    private String successURL = "";
    private String failureURL = "";

    public Download() {
        super("Download");
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        body.addChildElement(SOAP_FACTORY.createName("CommandKey")).setValue(this.commandKey);
        body.addChildElement(SOAP_FACTORY.createName("FileType")).setValue(this.fileType);
        body.addChildElement(SOAP_FACTORY.createName("URL")).setValue(this.url);
        body.addChildElement(SOAP_FACTORY.createName("Username")).setValue(this.username);
        body.addChildElement(SOAP_FACTORY.createName("Password")).setValue(this.password);
        body.addChildElement(SOAP_FACTORY.createName("FileSize")).setValue(String.valueOf(this.fileSize));
        body.addChildElement(SOAP_FACTORY.createName("TargetFileName")).setValue(this.targetFileName);
        body.addChildElement(SOAP_FACTORY.createName("DelaySeconds")).setValue(String.valueOf(this.delaySeconds));
        body.addChildElement(SOAP_FACTORY.createName("SuccessURL")).setValue(this.successURL);
        body.addChildElement(SOAP_FACTORY.createName("FailureURL")).setValue(this.failureURL);
    }

    public String getCommandKey() {
        return commandKey;
    }

    public void setCommandKey(String commandKey) {
        this.commandKey = commandKey;
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = firstNonNull(username, "");
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = firstNonNull(password, "");
    }

    public Integer getFileSize() {
        return fileSize;
    }

    public void setFileSize(Integer fileSize) {
        this.fileSize = fileSize;
    }

    public String getTargetFileName() {
        return targetFileName;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public Integer getDelaySeconds() {
        return delaySeconds;
    }

    public void setDelaySeconds(Integer delaySeconds) {
        this.delaySeconds = delaySeconds;
    }

    public String getSuccessURL() {
        return successURL;
    }

    public void setSuccessURL(String successURL) {
        this.successURL = successURL;
    }

    public String getFailureURL() {
        return failureURL;
    }

    public void setFailureURL(String failureURL) {
        this.failureURL = failureURL;
    }
}
