package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSRequest;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

/**
 * Used to create parameters.
 */
public class AddObject extends AbstractMessage implements ACSRequest {
    private String objectName;
    private String parameterKey;

    public AddObject() {
        super("AddObject");
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        SOAPElement oName = body.addChildElement(SOAP_FACTORY.createName("ObjectName"));
        oName.setValue(this.objectName);
        SOAPElement pKey = body.addChildElement(SOAP_FACTORY.createName("ParameterKey"));
        pKey.setValue(this.parameterKey);
    }

    public String getObjectName() {
        return objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getParameterKey() {
        return parameterKey;
    }

    public void setParameterKey(String parameterKey) {
        this.parameterKey = parameterKey;
    }
}
