package stargate.util.exception;

public final class ExceptionUtils {

    private ExceptionUtils() {}

    public static String buildMessage(String message, Object... argsAndThrowable) {
        if (argsAndThrowable == null) {
            argsAndThrowable = new Object[]{null};
        }
        if ((argsAndThrowable.length == 0) || (argsAndThrowable.length == 1 && argsAndThrowable[0] instanceof Throwable)) {
            return message;
        }
        return String.format(message, argsAndThrowable);
    }

    public static Throwable extractCause(Object... argsAndCause) {
        if (argsAndCause == null || argsAndCause.length == 0) {
            return null;
        }
        Object lastArg = argsAndCause[argsAndCause.length - 1];
        return lastArg instanceof Throwable ? (Throwable) lastArg : null;
    }
}
