package stargate.util.crypto;

import stargate.util.Base64;
import stargate.util.exception.StargateRuntimeException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DataEncryptor {
	public static final char[] DEFAULT_KEY = {'S', 't', '@', 'R', '9', '@', 't', '3'};

    public String encrypt(String data, char[] key) {
        byte[] encryptedBytes;
        try {
            byte[] sourceBytes = data.getBytes("UTF-8");
            Cipher aes = createCipher();
            aes.init(Cipher.ENCRYPT_MODE, getKey(key));
            encryptedBytes = aes.doFinal(sourceBytes);
        } catch (InvalidKeyException e) {
            throw new EncryptionException("Failed to encrypt data, passed key is not valid.", e);
        } catch (Exception e) {
            throw new StargateRuntimeException(e);
        }
        return new String(Base64.encode(encryptedBytes));
    }

    public String decrypt(String data, char[] key) {
        String decryptedData;
        try {
            Cipher aes = createCipher();
            aes.init(Cipher.DECRYPT_MODE, getKey(key));
            byte[] encodedBytes = Base64.decode(data);
            byte[] decodedBytes = aes.doFinal(encodedBytes);
            decryptedData = new String(decodedBytes, "UTF-8");
        } catch (InvalidKeyException e) {
            throw new DecryptionException("Passed key was not accepted.", e);
        } catch (BadPaddingException e) {
            throw new DecryptionException("Either passed key is not correct, or data is damaged.", e);
        } catch (Exception e) {
            throw new StargateRuntimeException(e);
        }
        return decryptedData;
    }

    private static Cipher createCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance("AES/ECB/PKCS5Padding");
    }

    private static SecretKeySpec getKey(char[] key) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA");
        digest.update(charArrayToByteArray(key));
        return new SecretKeySpec(digest.digest(), 0, 16, "AES");
    }

    private static byte[] charArrayToByteArray(char[] source) {
        byte[] result = new byte[source.length * 2];
        for (int i = 0; i < source.length; i++) {
            result[i * 2] = (byte) (source[i] >> 8);
            result[i * 2 + 1] = (byte) (source[i] & 0xFF);
        }
        return result;
    }
    
    static public void main(String args[]) {
    	System.out.println(new DataEncryptor().decrypt(args[0], new char[]{'S', 't', '@', 'R', '9', '@', 't', '3'}));
    }
}
