package com.cogniance.acs.util.soap;

import com.google.common.base.Objects;

import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import java.util.Iterator;

public class SOAPUtils {

    public static String getChildElementValue(SOAPElement parentElement, Name name) {
        return getChildElement(parentElement, name).getValue();
    }

    public static String getChildElementValue(SOAPElement parentElement, String name) {
        return getChildElement(parentElement, name).getValue();
    }

    /**
     * Get a child element from a SOAPElement
     *
     * @param parentElement
     *         The SOAP element
     * @param name
     *         The name of the child
     * @return The child SOAP element
     */
    public static SOAPElement getChildElement(SOAPElement parentElement, String name) {
        Iterator iterator = parentElement.getChildElements();
        while (iterator.hasNext()) {
            Node childNode = (Node) iterator.next();
            if (childNode instanceof SOAPElement) {
                SOAPElement childElement = (SOAPElement) childNode;
                if (Objects.equal(name, childElement.getLocalName())) {
                    return childElement;
                }
            }
        }
        return null;
    }

    public static SOAPElement getChildElement(SOAPElement parentElement, Name name) {
        Iterator iterator = parentElement.getChildElements(name);
        if (!iterator.hasNext()) {
            return null;
        }
        Node result = (Node) iterator.next();
        return result instanceof SOAPElement ? (SOAPElement) result : null;
    }
}
