package com.cogniance.acs.util;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.lang.System.getenv;

public class Utils {
    public static String getEnvironmentVariable(String name) {
        return checkNotNull(getenv(name), "%s environment variable is required.", name);
    }

    public static boolean isEnvironmentVariablePresent(String name) {
        return getenv(name) != null;
    }
    
    public static boolean isBlank(String text) {
    	return text == null || text.trim().isEmpty();
    }
}
