package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.util.soap.SOAPUtils;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;

/**
 * Response of how it went.
 */
public class SetParameterValuesResponse extends AbstractMessage implements CPEResponse {

    private ResponseStatus status;

    public SetParameterValuesResponse() {
        super("SetParameterValuesResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        status = ResponseStatus.byCode(Integer.parseInt(SOAPUtils.getChildElementValue(body, "Status")));
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
    }

    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    public ResponseStatus getStatus() {
        return status;
    }

    public enum ResponseStatus {
        /**
         * All Parameter changes have been validated and applied.
         */
        VALIDATED_AND_APPLIED(0),
        /*
         * All Parameter changes have been validated and committed, but some or all are not yet
         * applied (for example, if a reboot is required before the new values are applied).
         */
        VALIDATED_AND_COMMITTED(1);

        private int code;

        ResponseStatus(int code) {
            this.code = code;
        }

        public int getCode() {
            return code;
        }

        static public ResponseStatus byCode(int code) {
            for (ResponseStatus status : values()) {
                if (status.getCode() == code) {
                    return status;
                }
            }
            throw new IllegalArgumentException("Passed code was not found.");
        }
    }
}