package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.ACSResponse;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;

import static com.cogniance.acs.messaging.util.DataTypes.formatInt;

/**
 * Response to the inform message.
 */
public class InformResponse extends AbstractMessage implements ACSResponse {
    private Integer maxEnvelopes;

    public InformResponse() {
        super("InformResponse");
        this.maxEnvelopes = 1;
    }

    public InformResponse(Integer maxEnvelopes) {
        super("InformResponse");
        this.maxEnvelopes = maxEnvelopes;
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        body.addChildElement(SOAP_FACTORY.createName("MaxEnvelopes")).setValue(formatInt(this.maxEnvelopes));
    }

    public Integer getMaxEnvelopes() {
        return maxEnvelopes;
    }

    public void setMaxEnvelopes(Integer maxEnvelopes) {
        this.maxEnvelopes = maxEnvelopes;
    }
}
