package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.messaging.params.ParameterValueStruct;

import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import static com.cogniance.acs.util.soap.SOAPUtils.getChildElement;

/**
 * Response with values of the parameters sent.
 */
public class GetParameterValuesResponse extends AbstractMessage implements CPEResponse {
    private final List<ParameterValueStruct> parameterList = new ArrayList<ParameterValueStruct>();

    public GetParameterValuesResponse() {
        super("GetParameterValuesResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        parameterList.clear();

        Iterator paramListIt = getChildElement(body, "ParameterList").getChildElements(SOAP_FACTORY.createName("ParameterValueStruct"));
        while (paramListIt.hasNext()) {
            SOAPElement prm = (SOAPElement) paramListIt.next();
            this.parameterList.add(new ParameterValueStruct(prm));
        }
    }

    public List<ParameterValueStruct> getParameterList() {
        return parameterList;
    }
}
