/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectArgumentType<T>
implements ArgumentType<T> {
    private Class<T> type_;

    public ReflectArgumentType(Class<T> type) {
        this.type_ = type;
    }

    @Override
    public T convert(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        if (this.type_.isEnum()) {
            try {
                return Enum.valueOf(this.type_, value);
            }
            catch (IllegalArgumentException e) {
                this.throwArgumentParserException(parser, arg, value, e);
            }
        }
        Method m = null;
        try {
            m = this.type_.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            return this.convertUsingConstructor(parser, arg, value);
        }
        catch (SecurityException e) {
            this.handleInstatiationError(e);
        }
        if (!Modifier.isStatic(m.getModifiers()) || !this.type_.isAssignableFrom(m.getReturnType())) {
            return this.convertUsingConstructor(parser, arg, value);
        }
        Object obj = null;
        try {
            obj = m.invoke(null, value);
        }
        catch (IllegalAccessException e) {
            return this.convertUsingConstructor(parser, arg, value);
        }
        catch (IllegalArgumentException e) {
            this.handleInstatiationError(e);
        }
        catch (InvocationTargetException e) {
            this.throwArgumentParserException(parser, arg, value, e.getCause() == null ? e : e.getCause());
        }
        return (T)obj;
    }

    private T convertUsingConstructor(ArgumentParser parser, Argument arg, String value) throws ArgumentParserException {
        T obj = null;
        try {
            obj = this.type_.getConstructor(String.class).newInstance(value);
        }
        catch (InstantiationException e) {
            this.handleInstatiationError(e);
        }
        catch (IllegalAccessException e) {
            this.handleInstatiationError(e);
        }
        catch (InvocationTargetException e) {
            this.throwArgumentParserException(parser, arg, value, e.getCause() == null ? e : e.getCause());
        }
        catch (NoSuchMethodException e) {
            this.handleInstatiationError(e);
        }
        return obj;
    }

    private void throwArgumentParserException(ArgumentParser parser, Argument arg, String value, Throwable t) throws ArgumentParserException {
        throw new ArgumentParserException(String.format("could not convert '%s' to %s (%s)", value, this.type_.getSimpleName(), t.getMessage()), t, parser, arg);
    }

    private void handleInstatiationError(Exception e) {
        throw new IllegalArgumentException("reflect type conversion error", e);
    }
}

