/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.server;

import com.cogniance.acs.util.exception.ACSRuntimeException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;

public class ACSSecurityManager {
    private final HashLoginService loginService = new HashLoginService();
    private final ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
    private final Multimap<String, String> pathSpecToRoles = HashMultimap.create();

    public ACSSecurityManager(String authType) {
        if ("BASIC".equals(authType)) {
            this.securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        } else if ("DIGEST".equals(authType)) {
            this.securityHandler.setAuthenticator((Authenticator)new DigestAuthenticator());
        } else {
            throw new ACSRuntimeException("Passed auth type (%s) is not supported.", authType);
        }
        this.securityHandler.setLoginService((LoginService)this.loginService);
    }

    public SecurityHandler getWebSecurityHandler() {
        return this.securityHandler;
    }

    public void addUser(String login, String password, String ... roles) {
        if (roles == null) {
            return;
        }
        Credential credential = Credential.getCredential((String)password);
        this.loginService.putUser(login, credential, roles);
    }

    public void removeUser(String login) {
        this.loginService.removeUser(login);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPathAllowedRoles(String pathSpec, Collection<String> allowedRoles) {
        Multimap<String, String> multimap = this.pathSpecToRoles;
        synchronized (multimap) {
            this.pathSpecToRoles.removeAll((Object)pathSpec);
            this.pathSpecToRoles.putAll((Object)pathSpec, allowedRoles);
        }
        this.updateSecurityRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowPathForRole(String pathSpec, String role) {
        Multimap<String, String> multimap = this.pathSpecToRoles;
        synchronized (multimap) {
            this.pathSpecToRoles.put((Object)pathSpec, (Object)role);
        }
        this.updateSecurityRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forbidPathForRole(String pathSpec, String role) {
        Multimap<String, String> multimap = this.pathSpecToRoles;
        synchronized (multimap) {
            this.pathSpecToRoles.remove((Object)pathSpec, (Object)role);
        }
        this.updateSecurityRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSecurityRules() {
        Multimap<String, String> multimap = this.pathSpecToRoles;
        synchronized (multimap) {
            ArrayList<ConstraintMapping> mappings = new ArrayList<ConstraintMapping>(this.pathSpecToRoles.keySet().size());
            for (String pathSpec : this.pathSpecToRoles.keySet()) {
                Constraint constraint = new Constraint();
                constraint.setAuthenticate(true);
                constraint.setName(pathSpec);
                Collection roles = this.pathSpecToRoles.get((Object)pathSpec);
                String[] rolesArray = roles.toArray(new String[roles.size()]);
                constraint.setRoles(rolesArray);
                ConstraintMapping mapping = new ConstraintMapping();
                mapping.setConstraint(constraint);
                mapping.setPathSpec(pathSpec);
                mappings.add(mapping);
            }
            this.securityHandler.setConstraintMappings(mappings);
        }
    }
}

