/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.server;

import com.cogniance.acs.server.ACSSecurityManager;
import com.cogniance.acs.server.CWMPServlet;
import com.cogniance.acs.server.DeviceImpl;
import com.cogniance.acs.server.FileServingServlet;
import com.cogniance.acs.server.WebServer;
import com.cogniance.acs.server.api.ACS;
import com.cogniance.acs.server.api.ACSConfig;
import com.cogniance.acs.server.api.Device;
import com.cogniance.acs.server.api.FileDownloadData;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServlet;

public class ACSImpl
implements ACS {
    private ACSConfig config;
    private final Map<String, DeviceImpl> serialToDevice = new HashMap<String, DeviceImpl>();
    private ACSSecurityManager securityManager;
    private FileServingServlet fileServingServlet;
    private CWMPServlet cwmpServlet;
    private WebServer webServer;

    @Override
    public void start(ACSConfig config) {
        this.config = config;
        this.initializeSecurityManager();
        Map<HttpServlet, String> servlets = this.createServlets();
        this.webServer = new WebServer(config.getHost(), config.getPort());
        this.webServer.setupSecurityManager(this.securityManager);
        this.webServer.start(servlets);
    }

    private void initializeSecurityManager() {
        this.securityManager = new ACSSecurityManager(this.config.getAuthType());
        this.securityManager.allowPathForRole(this.config.getCwmpPostfix(), "admin");
        this.securityManager.allowPathForRole(this.config.getFileServingPathSpec(), "admin");
    }

    private Map<HttpServlet, String> createServlets() {
        this.fileServingServlet = new FileServingServlet(this.config.getFileServingDirectory());
        this.cwmpServlet = new CWMPServlet(this);
        HashMap<HttpServlet, String> servletToPathSpec = new HashMap<HttpServlet, String>();
        servletToPathSpec.put(this.cwmpServlet, this.config.getCwmpPostfix());
        servletToPathSpec.put(this.fileServingServlet, this.config.getFileServingPathSpec());
        return servletToPathSpec;
    }

    @Override
    public void stop() {
        this.webServer.stop();
    }

    @Override
    public DeviceImpl registerDevice(String serial, String acsLogin, String acsPassword) {
        DeviceImpl device = new DeviceImpl(serial, acsLogin, acsPassword);
        if (this.serialToDevice.containsKey(device.getSerial())) {
            throw new IllegalStateException("Device with such serial already exists: " + device.getSerial());
        }
        this.serialToDevice.put(device.getSerial(), device);
        this.securityManager.addUser(device.getACSLogin(), device.getACSPassword(), device.getSerial());
        this.securityManager.allowPathForRole(this.config.getCwmpPostfix(), device.getSerial());
        return device;
    }

    @Override
    public void setDeviceCredentials(Device device, String acsLogin, String acsPassword) {
        this.securityManager.removeUser(device.getACSLogin());
        DeviceImpl realDevice = this.serialToDevice.get(device.getSerial());
        realDevice.setACSLogin(acsLogin);
        realDevice.setACSPassword(acsPassword);
        this.securityManager.addUser(device.getACSLogin(), device.getACSPassword(), device.getSerial());
    }

    @Override
    public DeviceImpl getDevice(String serial) {
        return this.serialToDevice.get(serial);
    }

    @Override
    public void unregisterDevice(Device device) {
        this.serialToDevice.remove(device.getSerial());
        this.securityManager.forbidPathForRole(this.config.getCwmpPostfix(), device.getSerial());
        this.securityManager.removeUser(device.getACSLogin());
    }

    @Override
    public FileDownloadData exposeFileForDownload(File realFile, String pathSpec) throws IOException {
        this.fileServingServlet.exposeFile(realFile, pathSpec);
        URL url = new URL("http", this.config.getHost(), this.config.getPort(), this.config.getFileServingPostfix() + pathSpec);
        String role = "download:" + pathSpec;
        String login = UUID.randomUUID().toString();
        String password = UUID.randomUUID().toString();
        this.securityManager.allowPathForRole(url.getFile(), role);
        this.securityManager.addUser(login, password, role);
        return new FileDownloadData(url, login, password);
    }
}

