/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging.util;

import com.cogniance.acs.messaging.util.DataType;
import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;

public class DataTypes {
    public static String parseString(String text, int length) {
        return DataType.STRING.parse(text, length);
    }

    public static String formatString(String s, int length) {
        return DataType.STRING.format(s, length);
    }

    public static long parseUnsignedInt(String text) {
        return DataType.UNSIGNED_INT.parse(text);
    }

    public static String formatUnsignedInt(long i) {
        return DataType.UNSIGNED_INT.format(i);
    }

    public static int parseInt(String text) {
        return DataType.INT.parse(text);
    }

    public static String formatInt(int i) {
        return DataType.INT.format(i);
    }

    public static String formatDateTime(Date date) {
        return DataType.DATE.format(date);
    }

    public static Date parseDateTime(String text) {
        return DataType.DATE.parse(text);
    }

    public static boolean parseBoolean(String text) {
        return DataType.BOOLEAN.parse(text);
    }

    public static String formatBoolean(boolean value) {
        return DataType.BOOLEAN.format(value);
    }

    public static FormattedValue formatSimpleType(Object value) {
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
        for (DataType type : DataType.ALL_TYPES) {
            ParameterizedType pType = (ParameterizedType)type.getClass().getGenericSuperclass();
            Class valueType = GenericTypeReflector.erase((Type)pType.getActualTypeArguments()[0]);
            if (!valueType.isAssignableFrom(value.getClass())) continue;
            return new FormattedValue(type.getValueType(), type.format(value));
        }
        throw new IllegalArgumentException("Unsupported value type " + value.getClass());
    }

    public static DataType getDataType(Class<? extends DataType> dataTypeClass) {
        for (DataType dataType : DataType.ALL_TYPES) {
            if (!dataTypeClass.isAssignableFrom(dataType.getClass())) continue;
            return dataType;
        }
        throw new IllegalArgumentException("Passed data type was not found.");
    }

    public static Object parseSimpleType(String type, String text) {
        if (type == null) {
            throw new NullPointerException("Type must be specified.");
        }
        for (DataType dataType : DataType.ALL_TYPES) {
            if (!dataType.getValueType().equals(type)) continue;
            return dataType.parse(text);
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public static class FormattedValue {
        public final String type;
        public final String text;

        public FormattedValue(String type, String text) {
            this.type = type;
            this.text = text;
        }

        public String toString() {
            return String.format("FormattedValue {type: '%s', value: '%s'}", this.type, this.text);
        }
    }
}

