/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.messaging.params.ParameterInfoStruct;
import com.cogniance.acs.messaging.util.DataTypes;
import com.cogniance.acs.util.exception.ACSRuntimeException;
import com.cogniance.acs.util.soap.SOAPUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class GetParameterNamesResponse
extends AbstractMessage
implements CPEResponse {
    private final List<ParameterInfoStruct> parameterList = new ArrayList<ParameterInfoStruct>();

    public GetParameterNamesResponse() {
        super("GetParameterNamesResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.parameterList.clear();
        Iterator paramListIt = SOAPUtils.getChildElement((SOAPElement)body, "ParameterList").getChildElements(SOAP_FACTORY.createName("ParameterInfoStruct"));
        while (paramListIt.hasNext()) {
            SOAPElement prm = (SOAPElement)paramListIt.next();
            String name = SOAPUtils.getChildElementValue(prm, Names.Name);
            Boolean isWritable = DataTypes.parseBoolean(SOAPUtils.getChildElementValue(prm, Names.Writable));
            this.parameterList.add(new ParameterInfoStruct(name, isWritable != false ? ParameterInfoStruct.AccessMode.WRITABLE : ParameterInfoStruct.AccessMode.READ_ONLY));
        }
    }

    public List<ParameterInfoStruct> getParameterList() {
        return this.parameterList;
    }

    private static class Names {
        private static final Name Name;
        private static final Name Writable;

        private Names() {
        }

        static {
            try {
                Name = AbstractMessage.SOAP_FACTORY.createName("Name");
                Writable = AbstractMessage.SOAP_FACTORY.createName("Writable");
            }
            catch (SOAPException e) {
                throw new ACSRuntimeException("SOAP initialization failed.", new Object[]{e});
            }
        }
    }
}

