/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.server;

import com.cogniance.acs.server.ACSSecurityManager;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebServer {
    private static final Logger logger = LoggerFactory.getLogger(WebServer.class);
    private final String host;
    private final int port;
    private ACSSecurityManager acsSecurityManager;
    private Server server;

    public WebServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void setupSecurityManager(ACSSecurityManager securityManager) {
        this.acsSecurityManager = securityManager;
    }

    public void start(Map<HttpServlet, String> servletToPathSpec) {
        this.server = new Server();
        this.initConnectors();
        this.initServlets(servletToPathSpec);
        try {
            this.server.start();
        }
        catch (Exception e) {
            logger.error("Failed to start web server.", e);
            throw new RuntimeException(e);
        }
    }

    private void initConnectors() {
        SocketConnector httpConnector = new SocketConnector();
        httpConnector.setHost(this.host);
        httpConnector.setPort(this.port);
        httpConnector.setMaxIdleTime(30000);
        this.server.addConnector((Connector)httpConnector);
    }

    private void initServlets(Map<HttpServlet, String> servletToPathSpec) {
        HandlerList rootHandlerList = new HandlerList();
        ServletContextHandler sch = new ServletContextHandler();
        sch.setSessionHandler(new SessionHandler());
        sch.setSecurityHandler(this.acsSecurityManager.getWebSecurityHandler());
        for (Map.Entry<HttpServlet, String> entry : servletToPathSpec.entrySet()) {
            HttpServlet servlet = entry.getKey();
            String pathSpec = entry.getValue();
            sch.addServlet(new ServletHolder((Servlet)servlet), WebServer.normalizePathSpec(pathSpec));
        }
        rootHandlerList.addHandler((Handler)sch);
        this.server.setHandler((Handler)rootHandlerList);
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.error("Failed to stop web server.", e);
        }
    }

    private static String normalizePathSpec(String pathSpec) {
        return pathSpec.replaceAll("/*$", "");
    }
}

