/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging.params;

import com.cogniance.acs.util.soap.SOAPUtils;
import com.google.common.base.Objects;
import javax.xml.soap.SOAPElement;

public class DeviceId {
    private final String manufacturer;
    private final String oui;
    private final String productClass;
    private final String serialNumber;

    public DeviceId(String manufacturer, String oui, String productClass, String serialNumber) {
        this.manufacturer = manufacturer;
        this.oui = oui;
        this.productClass = productClass;
        this.serialNumber = serialNumber;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getOui() {
        return this.oui;
    }

    public String getProductClass() {
        return this.productClass;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.manufacturer, this.oui, this.productClass, this.serialNumber});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeviceId)) {
            return false;
        }
        DeviceId other = (DeviceId)obj;
        return Objects.equal((Object)this.manufacturer, (Object)other.manufacturer) && Objects.equal((Object)this.oui, (Object)other.oui) && Objects.equal((Object)this.productClass, (Object)other.productClass) && Objects.equal((Object)this.serialNumber, (Object)other.serialNumber);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Manufacturer", (Object)this.manufacturer).add("OUI", (Object)this.oui).add("Product class", (Object)this.productClass).add("Serial number", (Object)this.serialNumber).toString();
    }

    public static DeviceId from(SOAPElement deviceIdElement) {
        return new DeviceId(SOAPUtils.getChildElement(deviceIdElement, "Manufacturer").getValue(), SOAPUtils.getChildElement(deviceIdElement, "OUI").getValue(), SOAPUtils.getChildElement(deviceIdElement, "ProductClass").getValue(), SOAPUtils.getChildElement(deviceIdElement, "SerialNumber").getValue());
    }
}

