/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.api.ACSRequest;
import com.cogniance.acs.messaging.params.ParameterValueStruct;
import com.cogniance.acs.messaging.util.DataType;
import java.util.ArrayList;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class SetParameterValues
extends AbstractMessage
implements ACSRequest {
    private ArrayList<ParameterValueStruct> parameterList = new ArrayList();
    private String parameterKey;

    public SetParameterValues() {
        super("SetParameterValues");
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        SOAPElement paramList = body.addChildElement(SOAP_FACTORY.createName("ParameterList"));
        paramList.setAttribute("soapenc:arrayType", "cwmp:ParameterValueStruct[" + this.parameterList.size() + "]");
        for (ParameterValueStruct pvs : this.parameterList) {
            SOAPElement parameter = paramList.addChildElement("ParameterValueStruct");
            parameter.addChildElement("Name").setValue(pvs.getName());
            SOAPElement value = parameter.addChildElement("Value");
            value.setValue(pvs.getValue());
            value.setAttribute("xsi:type", pvs.getType());
        }
        body.addChildElement(SOAP_FACTORY.createName("ParameterKey")).setValue(String.valueOf(this.parameterKey));
    }

    public <T> SetParameterValues addParameter(String name, DataType<T> type, T value) {
        this.addParameter(new ParameterValueStruct(name, type.getValueType(), type.format(value)));
        return this;
    }

    public SetParameterValues addParameter(ParameterValueStruct pvs) {
        if (!this.parameterList.contains(pvs)) {
            this.parameterList.add(pvs);
        }
        return this;
    }

    public ArrayList<ParameterValueStruct> getParameterList() {
        return this.parameterList;
    }

    public void setParameterKey(String parameterKey) {
        this.parameterKey = parameterKey;
    }

    public String getParameterKey() {
        return this.parameterKey;
    }
}

