/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs;

import com.cogniance.acs.Combo;
import com.cogniance.acs.ComboException;
import com.cogniance.acs.Command;
import com.cogniance.acs.Config;
import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.Download;
import com.cogniance.acs.messaging.DownloadResponse;
import com.cogniance.acs.messaging.Fault;
import com.cogniance.acs.messaging.GetParameterValues;
import com.cogniance.acs.messaging.Inform;
import com.cogniance.acs.messaging.InformResponse;
import com.cogniance.acs.messaging.SetParameterValues;
import com.cogniance.acs.messaging.TransferComplete;
import com.cogniance.acs.messaging.api.Message;
import com.cogniance.acs.messaging.api.helping.ACSMessage;
import com.cogniance.acs.messaging.params.ParameterValueStruct;
import com.cogniance.acs.server.ACSImpl;
import com.cogniance.acs.server.api.ACS;
import com.cogniance.acs.server.api.ACSConfig;
import com.cogniance.acs.server.api.AwaitTimeoutException;
import com.cogniance.acs.server.api.Device;
import com.cogniance.acs.server.api.FileDownloadData;
import com.cogniance.acs.server.api.Session;
import com.cogniance.acs.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stargate.util.crypto.DataEncryptor;

public class Executor {
    private static final Logger logger = LoggerFactory.getLogger(Executor.class);
    private Config config;
    private Map<String, List<ACSMessage>> combos;
    private ACS acs;
    private Device device;

    public Executor(Config config) {
        this.config = config;
        this.combos = this.compileCombos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String firmwarePath) throws Exception {
        block9: {
            this.acs = new ACSImpl();
            this.startACS();
            try {
                this.prepareDevice();
                if (!Utils.isBlank(firmwarePath)) {
                    this.initiateFirmwareInstall(firmwarePath);
                    this.finishFirmwareInstall();
                    break block9;
                }
                Scanner scanner = new Scanner(System.in);
                while (true) {
                    logger.info("Enter command...");
                    String cmdLine = scanner.nextLine();
                    List<ACSMessage> messages = this.buildMessage(cmdLine);
                    if (messages.isEmpty()) continue;
                    Session session = this.initiateSession();
                    Object cpeMessage = session.awaitCPEMessage(10L, TimeUnit.SECONDS);
                    if (cpeMessage != null) {
                        session.completeSession();
                        this.device.awaitSessionFinished(5L, TimeUnit.SECONDS);
                        this.initiateSession();
                    }
                    for (ACSMessage message : messages) {
                        session.sendACSMessage(message);
                        Object response = session.awaitCPEMessage(1L, TimeUnit.MINUTES);
                    }
                    session.completeSession();
                }
            }
            catch (AwaitTimeoutException ex) {
                logger.warn("Got timeout");
            }
            finally {
                this.stopACS();
            }
        }
    }

    private void startACS() {
        ACSConfig acsConfig = new ACSConfig();
        acsConfig.setHost(this.config.getAcsHost());
        acsConfig.setPort(this.config.getAcsPort());
        acsConfig.setAuthType("DIGEST");
        acsConfig.setCwmpPostfix("/cpeManagement");
        acsConfig.setFileServingPostfix("/files");
        acsConfig.setFileServingDirectory(new File("/tmp/123/"));
        this.acs.start(acsConfig);
    }

    private void stopACS() {
        this.acs.stop();
    }

    private void prepareDevice() {
        this.device = this.acs.registerDevice(this.config.getDeviceSerial(), this.config.getAcsLogin(), this.getAcsPassword());
        this.device.setConnectionRequestUrl("http://" + this.config.getDeviceIp() + ":7547/");
        this.device.setConnectionRequestLogin("kduam7W7FkUWKfDZ");
        this.device.setConnectionRequestPassword("ukzCvRYZKQzuhS9h");
    }

    private String getAcsPassword() {
        String password = null;
        if (!Utils.isBlank(this.config.getAcsUnencryptedPassword())) {
            password = this.config.getAcsUnencryptedPassword();
        } else if (!Utils.isBlank(this.config.getAcsEncryptedPassword())) {
            DataEncryptor encryptor = new DataEncryptor();
            password = encryptor.decrypt(this.config.getAcsEncryptedPassword(), DataEncryptor.DEFAULT_KEY);
        }
        if (password == null) {
            logger.error("ACS password is not specified");
        }
        return password;
    }

    private void initiateFirmwareInstall(String firmwarePath) throws InterruptedException, AwaitTimeoutException, IOException {
        Session session = this.initiateSession();
        Object cpeMessage = session.awaitCPEMessage(10L, TimeUnit.SECONDS);
        while (cpeMessage != null) {
            session.sendACSMessage((ACSMessage)cpeMessage.createResponseMessage());
            cpeMessage = session.awaitCPEMessage(10L, TimeUnit.SECONDS);
        }
        Download downloadRequest = this.prepareDownload(firmwarePath);
        session.sendACSMessage(downloadRequest);
        Object response = session.awaitCPEMessage(1L, TimeUnit.MINUTES);
        if (response instanceof Fault) {
            throw new IllegalStateException(((Fault)response).getCwmpFaultString());
        }
        if (!(response instanceof DownloadResponse)) {
            throw new IllegalStateException("Invalid response: " + response);
        }
        session.completeSession();
        this.device.awaitSessionFinished(10L, TimeUnit.SECONDS);
    }

    private Session initiateSession() throws InterruptedException, AwaitTimeoutException {
        Session session = this.device.initiateSession(10L, TimeUnit.SECONDS);
        Inform inform = (Inform)session.awaitCPEMessage(10L, TimeUnit.SECONDS);
        session.sendACSMessage(new InformResponse());
        return session;
    }

    private Download prepareDownload(String firmwarePath) throws IOException {
        FileDownloadData data = this.acs.exposeFileForDownload(new File(firmwarePath), "/data.img.acs");
        Download downloadRequest = new Download();
        downloadRequest.setFileType("1 Firmware Upgrade Image");
        downloadRequest.setUsername(data.getUserName());
        downloadRequest.setPassword(data.getPassword());
        downloadRequest.setUrl(data.getFileUrl().toExternalForm());
        return downloadRequest;
    }

    private void finishFirmwareInstall() throws InterruptedException, AwaitTimeoutException {
        Session session = this.device.awaitSession(5L, TimeUnit.MINUTES);
        session.completeSession();
        for (Message message : session.getMessages()) {
            if (!(message instanceof TransferComplete)) continue;
            Integer faultCode = ((TransferComplete)message).getFaultStruct().getFaultCode();
            String faultString = ((TransferComplete)message).getFaultStruct().getFaultString();
            if (faultCode == 0) {
                return;
            }
            throw new IllegalStateException("Firmware install failed: " + faultCode + ", " + faultString);
        }
        throw new IllegalStateException("No firmware install occurred.");
    }

    private List<ACSMessage> buildMessage(String cmd) throws IOException {
        AbstractMessage values;
        ArrayList<ACSMessage> messages = new ArrayList<ACSMessage>();
        Map<String, String> params = this.parseCommandLine(cmd);
        if (!this.validateCmd(params)) {
            return messages;
        }
        if (params.get("cmd").equals("get")) {
            values = new GetParameterValues();
            ((GetParameterValues)values).addParameter(params.get("name"));
            messages.add((ACSMessage)((Object)values));
        } else if (params.get("cmd").equals("set")) {
            values = new SetParameterValues();
            ((SetParameterValues)values).addParameter(new ParameterValueStruct(params.get("name"), params.get("type"), params.get("value")));
            messages.add((ACSMessage)((Object)values));
        }
        if (params.get("cmd").equals("combo")) {
            if (!this.combos.containsKey(params.get("name"))) {
                logger.warn("Not found combo for name=" + params.get("name"));
            } else {
                messages.addAll((Collection<ACSMessage>)this.combos.get(params.get("name")));
            }
        }
        if (params.get("cmd").equals("upgrade")) {
            FileDownloadData data = this.acs.exposeFileForDownload(new File(params.get("file")), "/data.img.acs");
            Download downloadRequest = new Download();
            downloadRequest.setFileType("1 Firmware Upgrade Image");
            downloadRequest.setUsername(data.getUserName());
            downloadRequest.setPassword(data.getPassword());
            downloadRequest.setUrl(data.getFileUrl().toExternalForm());
        }
        return messages;
    }

    private Map<String, List<ACSMessage>> compileCombos() {
        HashMap<String, List<ACSMessage>> combos = new HashMap<String, List<ACSMessage>>();
        for (Combo combo : this.config.getCombos()) {
            if (!combo.isValid()) {
                logger.error("Combo " + combo.getName() + " is not valid");
                throw new ComboException();
            }
            combos.put(combo.getName(), this.compileCombo(combo));
        }
        return combos;
    }

    private List<ACSMessage> compileCombo(Combo combo) {
        ArrayList<ACSMessage> messages = new ArrayList<ACSMessage>();
        String currentCmd = null;
        AbstractMessage currentMsg = null;
        for (Command command : combo.getCommands()) {
            if (!command.getCmd().equals(currentCmd)) {
                AbstractMessage message;
                if (command.getCmd().equals("get")) {
                    message = new GetParameterValues();
                    messages.add((ACSMessage)((Object)message));
                    currentCmd = "get";
                    currentMsg = message;
                } else {
                    message = new SetParameterValues();
                    messages.add((ACSMessage)((Object)message));
                    currentCmd = "set";
                    currentMsg = message;
                }
            }
            if (command.getCmd().equals("get")) {
                ((GetParameterValues)currentMsg).addParameter(command.getName());
                continue;
            }
            ParameterValueStruct value = new ParameterValueStruct(command.getName(), command.getType(), command.getValue());
            ((SetParameterValues)currentMsg).addParameter(value);
        }
        return messages;
    }

    private Map<String, String> parseCommandLine(String cmd) {
        String[] pairs;
        HashMap<String, String> params = new HashMap<String, String>();
        if (Utils.isBlank(cmd)) {
            return params;
        }
        for (String pair : pairs = cmd.split(" ")) {
            if (Utils.isBlank(pair)) continue;
            if (!pair.contains("=")) {
                logger.warn("Invalid parameter found: " + pair);
                continue;
            }
            String[] arr = pair.split("=");
            if (!arr[0].equals("value")) {
                params.put(arr[0], arr[1]);
                continue;
            }
            params.put("value", cmd.substring(cmd.indexOf("value=") + 6));
            break;
        }
        return params;
    }

    private boolean validateCmd(Map<String, String> params) {
        if (!params.containsKey("name")) {
            logger.warn("Missing 'name' parameter...");
            return false;
        }
        if (!params.containsKey("cmd")) {
            logger.warn("Missing 'cmd' parameter...");
            return false;
        }
        String cmd = params.get("cmd");
        if (!(cmd.equals("get") || cmd.equals("set") || cmd.equals("combo"))) {
            logger.warn("Invalid 'cmd' parameter: " + cmd);
            return false;
        }
        if (cmd.equals("set")) {
            if (!params.containsKey("type")) {
                logger.warn("Missing 'type' parameter...");
                return false;
            }
            if (!params.containsKey("value")) {
                logger.warn("Missing 'value' parameter...");
                return false;
            }
        }
        return true;
    }
}

