/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.server;

import com.cogniance.acs.messaging.Fault;
import com.cogniance.acs.messaging.Inform;
import com.cogniance.acs.messaging.api.Message;
import com.cogniance.acs.messaging.api.helping.ACSMessage;
import com.cogniance.acs.messaging.api.helping.CPEMessage;
import com.cogniance.acs.server.api.AwaitTimeoutException;
import com.cogniance.acs.server.api.Session;
import com.cogniance.acs.util.exception.ACSRuntimeException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

class SessionImpl
implements Session {
    private final LinkedList<MessageInfo> messagesInfo = new LinkedList();
    private boolean holdRequests = false;
    private boolean cpeFinishedRequests = false;

    @Override
    public synchronized Inform getInform() {
        return (Inform)this.messagesInfo.getFirst().message;
    }

    @Override
    public synchronized Message getLastMessage() {
        return this.messagesInfo.getLast().message;
    }

    @Override
    public synchronized List<Message> getMessages() {
        ArrayList<Message> result = new ArrayList<Message>(this.messagesInfo.size());
        for (MessageInfo messageInfo : this.messagesInfo) {
            result.add(messageInfo.message);
        }
        return result;
    }

    @Override
    public void completeSession() throws InterruptedException {
        while (!this.isFinished()) {
            Object message;
            try {
                message = this.awaitCPEMessage(10L, TimeUnit.MINUTES);
            }
            catch (AwaitTimeoutException e) {
                throw new ACSRuntimeException("Failed to complete session: no message from CPE.", new Object[]{e});
            }
            if (message == null) {
                this.sendACSMessage(null);
                continue;
            }
            this.sendACSMessage((ACSMessage)message.createResponseMessage());
        }
    }

    @Override
    public synchronized void sendACSMessage(ACSMessage acsMessage) {
        this.registerMessage(acsMessage, MessageOrigin.ACS);
        this.updateHoldRequests(acsMessage);
    }

    private void updateHoldRequests(ACSMessage acsMessage) {
        if (acsMessage != null && acsMessage.isHoldRequests()) {
            this.holdRequests = true;
        } else if (acsMessage == null || !acsMessage.isHoldRequests()) {
            this.holdRequests = false;
        }
    }

    public synchronized void registerCPEMessage(CPEMessage cpeMessage) {
        this.registerMessage(cpeMessage, MessageOrigin.CPE);
        this.updateCPEFinishedRequests(cpeMessage);
    }

    private void updateCPEFinishedRequests(CPEMessage cpeMessage) {
        if (!this.holdRequests && cpeMessage == null) {
            this.cpeFinishedRequests = true;
        }
    }

    private void registerMessage(Message message, MessageOrigin origin) {
        this.messagesInfo.add(new MessageInfo(message, origin));
        this.notifyAll();
    }

    @Override
    public synchronized <T extends CPEMessage> T awaitCPEMessage(long timeout, TimeUnit timeUnit) throws InterruptedException, AwaitTimeoutException {
        long millisToWait;
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        while ((this.messagesInfo.isEmpty() || this.messagesInfo.getLast().origin != MessageOrigin.CPE) && (millisToWait = TimeUnit.NANOSECONDS.toMillis(deadline - System.nanoTime())) > 0L) {
            this.wait(millisToWait);
        }
        if (this.messagesInfo.isEmpty() || this.messagesInfo.getLast().origin != MessageOrigin.CPE) {
            throw new AwaitTimeoutException();
        }
        return (T)((CPEMessage)this.messagesInfo.getLast().message);
    }

    public synchronized ACSMessage awaitACSMessage(long timeout, TimeUnit timeUnit) throws InterruptedException, AwaitTimeoutException {
        long millisToWait;
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        while (this.messagesInfo.getLast().origin != MessageOrigin.ACS && (millisToWait = TimeUnit.NANOSECONDS.toMillis(deadline - System.nanoTime())) > 0L) {
            this.wait(millisToWait);
        }
        if (this.messagesInfo.getLast().origin == MessageOrigin.ACS) {
            return (ACSMessage)this.messagesInfo.getLast().message;
        }
        throw new AwaitTimeoutException();
    }

    @Override
    public synchronized boolean isFinished() {
        if (this.messagesInfo.isEmpty()) {
            return false;
        }
        if (this.messagesInfo.getLast().message instanceof Fault) {
            return true;
        }
        if (this.messagesInfo.size() % 2 == 0) {
            return this.messagesInfo.getLast().message == null && this.cpeFinishedRequests;
        }
        return false;
    }

    @Override
    public synchronized boolean isCPEFinishedRequests() {
        return this.cpeFinishedRequests;
    }

    private static enum MessageOrigin {
        ACS,
        CPE;

    }

    private static class MessageInfo {
        Message message;
        Date occurrenceTime;
        MessageOrigin origin;

        public MessageInfo(Message message, MessageOrigin origin) {
            this.message = message;
            this.occurrenceTime = new Date();
            this.origin = origin;
        }
    }
}

