/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.server;

import com.cogniance.acs.server.SessionImpl;
import com.cogniance.acs.server.api.AwaitTimeoutException;
import com.cogniance.acs.server.api.Device;
import com.cogniance.acs.server.api.Session;
import com.cogniance.acs.util.exception.ACSRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eclipse.jetty.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeviceImpl
implements Device {
    private static final Logger logger = LoggerFactory.getLogger(DeviceImpl.class);
    private final List<String> protocolViolations = new ArrayList<String>();
    private final String serial;
    private String acsLogin;
    private String acsPassword;
    private String connectionRequestUrl;
    private String connectionRequestLogin;
    private String connectionRequestPassword;
    private final Object sessionMonitor = new Object();
    private SessionImpl currentSession;

    public DeviceImpl(String serial, String acsLogin, String acsPassword) {
        this.serial = serial;
        this.acsLogin = acsLogin;
        this.acsPassword = acsPassword;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public String getConnectionRequestUrl() {
        return this.connectionRequestUrl;
    }

    @Override
    public void setConnectionRequestUrl(String connectionRequestUrl) {
        this.connectionRequestUrl = connectionRequestUrl;
    }

    @Override
    public String getConnectionRequestLogin() {
        return this.connectionRequestLogin;
    }

    @Override
    public void setConnectionRequestLogin(String connectionRequestLogin) {
        this.connectionRequestLogin = connectionRequestLogin;
    }

    @Override
    public String getConnectionRequestPassword() {
        return this.connectionRequestPassword;
    }

    @Override
    public void setConnectionRequestPassword(String connectionRequestPassword) {
        this.connectionRequestPassword = connectionRequestPassword;
    }

    @Override
    public String getACSLogin() {
        return this.acsLogin;
    }

    public void setACSLogin(String acsLogin) {
        this.acsLogin = acsLogin;
    }

    @Override
    public String getACSPassword() {
        return this.acsPassword;
    }

    public void setACSPassword(String acsPassword) {
        this.acsPassword = acsPassword;
    }

    @Override
    public boolean isInSession() {
        return this.currentSession != null;
    }

    @Override
    public SessionImpl getCurrentSession() {
        return this.currentSession;
    }

    @Override
    public Session awaitSession(long timeout, TimeUnit timeUnit) throws AwaitTimeoutException, InterruptedException {
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        Object object = this.sessionMonitor;
        synchronized (object) {
            long millisToWait;
            while (this.currentSession == null && (millisToWait = TimeUnit.NANOSECONDS.toMillis(deadline - System.nanoTime())) > 0L) {
                this.sessionMonitor.wait(millisToWait);
            }
            if (this.currentSession != null) {
                return this.currentSession;
            }
            throw new AwaitTimeoutException();
        }
    }

    @Override
    public void awaitSessionFinished(long timeout, TimeUnit timeUnit) throws AwaitTimeoutException, InterruptedException {
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        Object object = this.sessionMonitor;
        synchronized (object) {
            long millisToWait;
            while (this.currentSession != null && (millisToWait = TimeUnit.NANOSECONDS.toMillis(deadline - System.nanoTime())) > 0L) {
                this.sessionMonitor.wait(millisToWait);
            }
            if (this.currentSession == null) {
                return;
            }
            throw new AwaitTimeoutException();
        }
    }

    @Override
    public Session initiateSession(long timeout, TimeUnit timeUnit) throws InterruptedException, AwaitTimeoutException {
        long deadline = System.nanoTime() + timeUnit.toNanos(timeout);
        if (this.currentSession != null) {
            throw new IllegalStateException("Session already in progress, can't initiate another one.");
        }
        this.sendConnectionRequest();
        return this.awaitSession(deadline - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public void sendConnectionRequest() {
        logger.info("Sending connection request to {} at {} user: {}", this.serial, this.connectionRequestUrl, this.connectionRequestLogin);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.connectionRequestLogin, this.connectionRequestPassword));
        httpClient.setReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
        HttpGet request = new HttpGet(this.connectionRequestUrl);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (!HttpStatus.isSuccess((int)response.getStatusLine().getStatusCode())) {
                logger.warn("Failed to send connection request: {}", (Object)response.getStatusLine());
                throw new ACSRuntimeException("Connection request rejected: %s", response.getStatusLine());
            }
        }
        catch (IOException e) {
            logger.warn("Failed to send connection request.", e);
            throw new ACSRuntimeException("Failed to send connection request to the CPE at %s.", this.connectionRequestUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl initializeSession() {
        Object object = this.sessionMonitor;
        synchronized (object) {
            this.currentSession = new SessionImpl();
            this.sessionMonitor.notifyAll();
            return this.currentSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession() {
        Object object = this.sessionMonitor;
        synchronized (object) {
            this.currentSession = null;
            this.sessionMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProtocolViolation(String reason) {
        logger.error("Protocol violation happened.\nDevice: {}\nReason: {}", (Object)this, (Object)reason);
        List<String> list = this.protocolViolations;
        synchronized (list) {
            this.protocolViolations.add(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listProtocolViolations() {
        List<String> list = this.protocolViolations;
        synchronized (list) {
            return new ArrayList<String>(this.protocolViolations);
        }
    }
}

