/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging.util;

import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public abstract class DataType<T> {
    public static final CpeString STRING = new CpeString();
    public static final CpeUnsignedInt UNSIGNED_INT = new CpeUnsignedInt();
    public static final CpeInt INT = new CpeInt();
    public static final CpeDate DATE = new CpeDate();
    public static final CpeBoolean BOOLEAN = new CpeBoolean();
    public static final DataType[] ALL_TYPES = new DataType[]{STRING, UNSIGNED_INT, INT, DATE, BOOLEAN};
    public static final Map<String, DataType> NAME_TO_TYPE = ImmutableMap.of((Object)"string", (Object)STRING, (Object)"uint", (Object)UNSIGNED_INT, (Object)"int", (Object)INT, (Object)"date", (Object)DATE, (Object)"bool", (Object)BOOLEAN);

    public abstract T parse(String var1);

    public abstract String format(T var1);

    public abstract String getValueType();

    public static DataType fromValueType(String valueType) {
        String normalizedValueType = valueType.startsWith("xsd:") ? valueType : "xsd:" + valueType;
        for (DataType dataType : ALL_TYPES) {
            if (!dataType.getValueType().equals(normalizedValueType)) continue;
            return dataType;
        }
        throw new IllegalArgumentException("Unknown data type: " + valueType);
    }

    private DataType() {
    }

    public static class CpeBoolean
    extends DataType<Boolean> {
        @Override
        public Boolean parse(String text) {
            if (!Arrays.asList("0", "1", "true", "false").contains(text)) {
                throw new IllegalArgumentException("invalid boolean " + text);
            }
            return text.equals("1") || text.equals("true");
        }

        @Override
        public String format(Boolean value) {
            return value != false ? "1" : "0";
        }

        @Override
        public String getValueType() {
            return "xsd:boolean";
        }
    }

    public static class CpeDate
    extends DataType<Date> {
        public static final String UNKNOWN_TIME = "0001-01-01T00:00:00Z";
        private static String[] DATE_TIME_PATTERNS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss"};

        @Override
        public Date parse(String text) {
            if (text == null || text.equals(UNKNOWN_TIME)) {
                return null;
            }
            for (int i = 0; i < DATE_TIME_PATTERNS.length; ++i) {
                try {
                    return CpeDate.dateTimeFormat(i).parse(text);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            throw new IllegalArgumentException("Can't parse dateTime " + text);
        }

        @Override
        public String format(Date value) {
            return value != null ? CpeDate.dateTimeFormat(0).format(value) : UNKNOWN_TIME;
        }

        @Override
        public String getValueType() {
            return "xsd:dateTime";
        }

        private static SimpleDateFormat dateTimeFormat(int patternIdx) {
            String pattern = DATE_TIME_PATTERNS[patternIdx];
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            format.setTimeZone(TimeZone.getTimeZone("UTC-0"));
            return format;
        }
    }

    public static class CpeInt
    extends DataType<Integer> {
        @Override
        public Integer parse(String text) {
            return Integer.valueOf(text);
        }

        @Override
        public String format(Integer value) {
            return value.toString();
        }

        @Override
        public String getValueType() {
            return "xsd:int";
        }
    }

    public static class CpeUnsignedInt
    extends DataType<Long> {
        @Override
        public Long parse(String text) {
            long value = Long.parseLong(text);
            if (value < 0L || value >= 0x100000000L) {
                throw new IllegalArgumentException("unsignedInt out of range " + value);
            }
            return value;
        }

        @Override
        public String format(Long value) {
            if (value < 0L || value >= 0x100000000L) {
                throw new IllegalArgumentException("unsignedInt out of range " + value);
            }
            return value.toString();
        }

        @Override
        public String getValueType() {
            return "xsd:unsignedInt";
        }
    }

    public static class CpeString
    extends DataType<String> {
        public String parse(String text, int length) {
            if (text != null && text.length() > length) {
                throw new IllegalArgumentException("Length > " + length + ": " + text);
            }
            return text == null || text.length() == 0 ? null : text;
        }

        @Override
        public String parse(String text) {
            return this.parse(text, 256);
        }

        public String format(String value, int length) {
            if (value != null && value.length() > length) {
                throw new IllegalArgumentException("Length > " + length + ": " + value);
            }
            return value == null ? "" : value;
        }

        @Override
        public String format(String value) {
            return this.format(value, 256);
        }

        @Override
        public String getValueType() {
            return "xsd:string";
        }
    }
}

