/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.api.CPERequest;
import com.cogniance.acs.messaging.params.FaultStruct;
import com.cogniance.acs.messaging.util.DataType;
import com.cogniance.acs.util.soap.SOAPUtils;
import java.util.Date;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class TransferComplete
extends AbstractMessage
implements CPERequest {
    private String commandKey;
    private FaultStruct faultStruct;
    private Date startTime;
    private Date completeTime;

    public TransferComplete() {
        super("TransferComplete");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.commandKey = SOAPUtils.getChildElementValue((SOAPElement)body, "CommandKey");
        SOAPElement fCode = SOAPUtils.getChildElement((SOAPElement)body, "FaultStruct");
        if (fCode != null) {
            this.faultStruct = new FaultStruct();
            this.faultStruct.setFaultCode(Integer.parseInt(SOAPUtils.getChildElementValue(fCode, "FaultCode")));
            this.faultStruct.setFaultString(SOAPUtils.getChildElementValue(fCode, "FaultString"));
        } else {
            this.faultStruct = null;
        }
        this.startTime = DataType.DATE.parse(SOAPUtils.getChildElementValue((SOAPElement)body, "StartTime"));
        this.completeTime = DataType.DATE.parse(SOAPUtils.getChildElementValue((SOAPElement)body, "CompleteTime"));
    }

    public String getCommandKey() {
        return this.commandKey;
    }

    public void setCommandKey(String commandKey) {
        this.commandKey = commandKey;
    }

    public FaultStruct getFaultStruct() {
        return this.faultStruct;
    }

    public void setFaultStruct(FaultStruct faultStruct) {
        this.faultStruct = faultStruct;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getCompleteTime() {
        return this.completeTime;
    }

    public void setCompleteTime(Date completeTime) {
        this.completeTime = completeTime;
    }
}

