/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.api.CPERequest;
import com.cogniance.acs.messaging.params.DeviceId;
import com.cogniance.acs.messaging.params.EventStruct;
import com.cogniance.acs.messaging.params.ParameterValueStruct;
import com.cogniance.acs.util.soap.SOAPUtils;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class Inform
extends AbstractMessage
implements CPERequest {
    private DeviceId deviceId;
    private ArrayList<EventStruct> events;
    private Integer maxEnvelopes;
    private String currentTime;
    private Integer retryCount;
    private ArrayList<ParameterValueStruct> parameterList;

    public Inform() {
        super("Inform");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.deviceId = DeviceId.from(SOAPUtils.getChildElement((SOAPElement)body, "DeviceId"));
        this.maxEnvelopes = Integer.parseInt(SOAPUtils.getChildElementValue((SOAPElement)body, "MaxEnvelopes"));
        this.retryCount = Integer.parseInt(SOAPUtils.getChildElementValue((SOAPElement)body, "RetryCount"));
        this.currentTime = SOAPUtils.getChildElementValue((SOAPElement)body, "RetryCount");
        this.parseSOAPParameterList(SOAPUtils.getChildElement((SOAPElement)body, "ParameterList"));
        this.parseSOAPEvents(SOAPUtils.getChildElement((SOAPElement)body, "Event"));
    }

    private void parseSOAPEvents(SOAPElement eventsElement) throws SOAPException {
        this.events = new ArrayList();
        Iterator eventsIt = eventsElement.getChildElements(SOAP_FACTORY.createName("EventStruct"));
        Name eCode = SOAP_FACTORY.createName("EventCode");
        Name eCmdKey = SOAP_FACTORY.createName("CommandKey");
        while (eventsIt.hasNext()) {
            SOAPElement event = (SOAPElement)eventsIt.next();
            String code = SOAPUtils.getChildElementValue(event, eCode);
            String cmdkey = SOAPUtils.getChildElementValue(event, eCmdKey);
            if (cmdkey == null) {
                cmdkey = "";
            }
            this.events.add(new EventStruct(code, cmdkey));
        }
    }

    private void parseSOAPParameterList(SOAPElement parameterListElement) throws SOAPException {
        this.parameterList = new ArrayList();
        Iterator paramListIt = parameterListElement.getChildElements(SOAP_FACTORY.createName("ParameterValueStruct"));
        while (paramListIt.hasNext()) {
            SOAPElement prm = (SOAPElement)paramListIt.next();
            this.parameterList.add(new ParameterValueStruct(prm));
        }
    }

    public DeviceId getDeviceId() {
        return this.deviceId;
    }

    public ArrayList<EventStruct> getEvents() {
        return this.events;
    }

    public Integer getMaxEnvelopes() {
        return this.maxEnvelopes;
    }

    public String getCurrentTime() {
        return this.currentTime;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public ArrayList<ParameterValueStruct> getParameterList() {
        return this.parameterList;
    }

    public String getParameterValue(String parameterName) {
        for (ParameterValueStruct pvs : this.parameterList) {
            if (!Objects.equal((Object)pvs.getName(), (Object)parameterName)) continue;
            return pvs.getValue();
        }
        return null;
    }

    public boolean containsEvent(String eventCode) {
        for (EventStruct eventStruct : this.events) {
            if (!Objects.equal((Object)eventStruct.getEvent(), (Object)eventCode)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEvent(String eventCode, String commandKey) {
        for (EventStruct eventStruct : this.events) {
            if (!Objects.equal((Object)eventStruct.getEvent(), (Object)eventCode) || !Objects.equal((Object)eventStruct.getCommandKey(), (Object)commandKey)) continue;
            return true;
        }
        return false;
    }
}

