/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.util.soap.SOAPUtils;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class DownloadResponse
extends AbstractMessage
implements CPEResponse {
    private ResponseStatus status;
    private String startTime;
    private String completeTime;

    public DownloadResponse() {
        super("DownloadResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.status = ResponseStatus.byCode(Integer.parseInt(SOAPUtils.getChildElementValue((SOAPElement)body, "Status")));
        this.startTime = SOAPUtils.getChildElementValue((SOAPElement)body, "StartTime");
        this.completeTime = SOAPUtils.getChildElementValue((SOAPElement)body, "CompleteTime");
    }

    public ResponseStatus getStatus() {
        return this.status;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getCompleteTime() {
        return this.completeTime;
    }

    public static enum ResponseStatus {
        DOWNLOADED_AND_APPLIED(0),
        DOWNLOADED_AND_AWAITING(1);

        private int code;

        private ResponseStatus(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static ResponseStatus byCode(int code) {
            for (ResponseStatus status : ResponseStatus.values()) {
                if (status.getCode() != code) continue;
                return status;
            }
            throw new IllegalArgumentException("Passed code was not found.");
        }
    }
}

