/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.api.Message;
import com.cogniance.acs.messaging.util.DataTypes;
import com.cogniance.acs.util.exception.ACSRuntimeException;
import com.cogniance.acs.util.soap.SOAPUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public abstract class AbstractMessage
implements Message {
    protected static final String URN_CWMP = "urn:dslforum-org:cwmp-1-0";
    protected static final String CWMP = "cwmp";
    protected static final String SOAP_ENC = "soapenc";
    public static final String MESSAGE_SKELETON = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:cwmp=\"urn:dslforum-org:cwmp-1-0\" soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n<soap:Header>\r\n</soap:Header>\r\n<soap:Body>\r\n</soap:Body>\r\n</soap:Envelope>";
    protected static final SOAPFactory SOAP_FACTORY;
    protected static final MessageFactory MESSAGE_FACTORY;
    private final String name;
    private SOAPMessage cachedSOAP;
    private String id = UUID.randomUUID().toString();
    private String holdRequests = "false";

    public static String getRequestName(SOAPMessage msg) throws SOAPException {
        if (msg.getSOAPBody().hasFault()) {
            return "Fault";
        }
        SOAPBodyElement sbe = null;
        Iterator iter = msg.getSOAPBody().getChildElements();
        while (iter.hasNext()) {
            Node n = (Node)iter.next();
            if (n.getNodeType() != 1) continue;
            sbe = (SOAPBodyElement)n;
        }
        String name = sbe.getNodeName();
        if (name.startsWith("cwmp:")) {
            name = name.substring(5);
        }
        return name;
    }

    public static AbstractMessage createMessage(String messageName, SOAPMessage soapMessage) throws SOAPException {
        AbstractMessage message = AbstractMessage.createMessageByName(messageName);
        if (soapMessage != null) {
            message.fromSOAP(soapMessage);
        }
        return message;
    }

    public static AbstractMessage createMessageByContent(String messageContent) throws IOException {
        if (messageContent == null || messageContent.isEmpty()) {
            return null;
        }
        try {
            SOAPMessage soapMessage = MESSAGE_FACTORY.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            StreamSource source = new StreamSource(new StringReader(messageContent));
            soapPart.setContent((Source)source);
            return AbstractMessage.createMessageByContent(soapMessage);
        }
        catch (SOAPException e) {
            throw new ACSRuntimeException("Failed to create message from: %s", new Object[]{messageContent, e});
        }
    }

    public static AbstractMessage createMessageByContent(SOAPMessage messageContent) throws IOException, SOAPException {
        String messageName = AbstractMessage.getRequestName(messageContent);
        return AbstractMessage.createMessage(messageName, messageContent);
    }

    public static AbstractMessage createMessageByName(String messageName) {
        String packageName = AbstractMessage.class.getPackage().getName();
        try {
            Class<?> messageClass = Class.forName(packageName + "." + messageName);
            return (AbstractMessage)messageClass.newInstance();
        }
        catch (Exception ex) {
            throw new ACSRuntimeException("Failed to create message %s", messageName, ex);
        }
    }

    public AbstractMessage(String name) {
        this.name = name;
    }

    @Override
    public AbstractMessage createResponseMessage() {
        if (this.name.endsWith("Response") || this.name.equals("Fault")) {
            return null;
        }
        AbstractMessage response = AbstractMessage.createMessageByName(this.name + "Response");
        response.setId(this.id);
        return response;
    }

    private SOAPBodyElement getSOAPRequestBody(SOAPBody soapBody) throws SOAPException {
        Iterator it = soapBody.getChildElements();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getNodeType() != 1) continue;
            return (SOAPBodyElement)node;
        }
        throw new SOAPException("No request body was found.");
    }

    public void fromSOAP(SOAPMessage soapMessage) throws SOAPException {
        this.cachedSOAP = soapMessage;
        this.parseSOAPHeader(soapMessage.getSOAPHeader());
        this.parseSOAPBody(this.getSOAPRequestBody(soapMessage.getSOAPBody()));
    }

    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    private void parseSOAPHeader(SOAPHeader header) {
        if (header == null) {
            return;
        }
        try {
            this.id = null;
            this.id = SOAPUtils.getChildElementValue((SOAPElement)header, Names.ID);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.holdRequests = null;
            this.holdRequests = SOAPUtils.getChildElementValue((SOAPElement)header, Names.HoldRequests);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SOAPMessage toSOAP() throws SOAPException {
        SOAPMessage soapMessage = this.createSOAPMessage();
        this.fillSOAPHeader(soapMessage.getSOAPHeader());
        Name messageName = SOAP_FACTORY.createName(this.getName(), CWMP, URN_CWMP);
        this.fillSOAPBody(soapMessage.getSOAPBody().addBodyElement(messageName));
        this.cachedSOAP = soapMessage;
        return soapMessage;
    }

    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    private SOAPMessage createSOAPMessage() throws SOAPException {
        SOAPMessage soapMessage;
        ByteArrayInputStream in = new ByteArrayInputStream(MESSAGE_SKELETON.getBytes());
        try {
            soapMessage = MESSAGE_FACTORY.createMessage(null, (InputStream)in);
        }
        catch (IOException e) {
            throw new ACSRuntimeException("I/O failure while working with ByteArrayInputStream :-/", new Object[]{e});
        }
        return soapMessage;
    }

    private void fillSOAPHeader(SOAPHeader header) throws SOAPException {
        SOAPHeaderElement idHeader = header.addHeaderElement(Names.ID);
        idHeader.setValue(this.id);
        idHeader.setAttribute("mustUnderstand", "1");
        SOAPHeaderElement holdRequestsHeader = header.addHeaderElement(Names.HoldRequests);
        holdRequestsHeader.setValue(DataTypes.formatBoolean(this.isHoldRequests()));
        holdRequestsHeader.setAttribute("mustUnderstand", "1");
    }

    public static String removeInvalidXMLCharacters(String s) {
        int curr;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); i += Character.charCount(curr)) {
            curr = s.codePointAt(i);
            if (!(curr == 9 || curr == 10 || curr == 13 || curr >= 32 && curr <= 55295 || curr >= 57344 && curr <= 65533) && (curr < 65536 || curr > 0x10FFFF)) continue;
            out.append(Character.toChars(curr));
        }
        return out.toString();
    }

    @Override
    public void setHoldRequests(String holdRequests) {
        this.holdRequests = holdRequests;
    }

    @Override
    public void setHoldRequests(boolean holdRequests) {
        this.holdRequests = DataTypes.formatBoolean(holdRequests);
    }

    @Override
    public String getHoldRequests() {
        return this.holdRequests;
    }

    @Override
    public boolean isHoldRequests() {
        return this.holdRequests == null || DataTypes.parseBoolean(this.holdRequests);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.cachedSOAP == null) {
                this.toSOAP();
            }
            this.cachedSOAP.writeTo((OutputStream)baos);
            return new String(baos.toByteArray());
        }
        catch (Exception ignore) {
            return super.toString();
        }
    }

    static {
        try {
            SOAP_FACTORY = SOAPFactory.newInstance();
            MESSAGE_FACTORY = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new ACSRuntimeException("Failed to initialize SOAP factory for messages.", new Object[]{e});
        }
    }

    private static class Names {
        private static final Name HoldRequests;
        private static final Name ID;

        private Names() {
        }

        static {
            try {
                HoldRequests = SOAP_FACTORY.createName("HoldRequests", AbstractMessage.CWMP, AbstractMessage.URN_CWMP);
                ID = SOAP_FACTORY.createName("ID", AbstractMessage.CWMP, AbstractMessage.URN_CWMP);
            }
            catch (SOAPException e) {
                throw new ACSRuntimeException("SOAP initialization failed.", new Object[]{e});
            }
        }
    }
}

