/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.server;

import com.cogniance.acs.util.exception.ACSRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileServingServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(FileServingServlet.class);
    private final Map<String, File> pathSpecToFile = new HashMap<String, File>();
    private final File filesUploadDirectory;

    public FileServingServlet(File filesUploadDirectory) {
        this.filesUploadDirectory = filesUploadDirectory;
        try {
            FileUtils.forceMkdir((File)filesUploadDirectory);
        }
        catch (IOException e) {
            throw new ACSRuntimeException("Failed to create directory for files upload.", new Object[]{e});
        }
    }

    void exposeFile(File originalFile, String pathSpec) {
        if (this.pathSpecToFile.containsKey(pathSpec)) {
            logger.warn("Overwriting path spec - file mapping for: {}", (Object)pathSpec);
        }
        this.pathSpecToFile.put(pathSpec, originalFile);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String fileRelativePath = req.getPathInfo();
        File fileToGet = this.pathSpecToFile.get(fileRelativePath);
        if (fileToGet == null) {
            resp.sendError(404);
            return;
        }
        resp.setStatus(200);
        resp.setContentLength((int)fileToGet.length());
        resp.setContentType("application/octet-stream");
        FileUtils.copyFile((File)fileToGet, (OutputStream)resp.getOutputStream());
        resp.getOutputStream().close();
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String fileRelativePath = req.getPathInfo();
        File fileToPut = new File(this.filesUploadDirectory, fileRelativePath);
        if (!FileServingServlet.isParentChild(this.filesUploadDirectory, fileToPut)) {
            resp.sendError(403);
            return;
        }
        if (fileToPut.exists()) {
            resp.sendError(409, String.format("File '%s' already exists, overwrites forbidden.", fileRelativePath));
            return;
        }
        FileUtils.forceMkdir((File)fileToPut.getParentFile());
        FileUtils.copyInputStreamToFile((InputStream)req.getInputStream(), (File)fileToPut);
        resp.setStatus(204);
    }

    private static boolean isParentChild(File parent, File child) throws IOException {
        String parentPath = parent.getCanonicalPath();
        String childPath = child.getCanonicalPath();
        return childPath.startsWith(parentPath);
    }
}

