/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging.params;

import com.cogniance.acs.messaging.util.DataType;
import com.cogniance.acs.util.soap.SOAPUtils;
import com.google.common.base.Objects;
import javax.xml.soap.SOAPElement;

public class ParameterValueStruct
implements Comparable<ParameterValueStruct> {
    private String name;
    private String value;
    private String type;

    public ParameterValueStruct(SOAPElement element) {
        SOAPElement valueElement = SOAPUtils.getChildElement(element, "Value");
        SOAPElement nameElement = SOAPUtils.getChildElement(element, "Name");
        this.name = nameElement.getValue();
        this.type = ParameterValueStruct.normalizeType(valueElement.getAttribute("xsi:type"));
        this.value = valueElement.getValue();
    }

    public ParameterValueStruct(String name, String type, String value) {
        this.name = name;
        this.value = value;
        this.type = ParameterValueStruct.normalizeType(type);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public DataType getDataType() {
        return DataType.fromValueType(this.type);
    }

    public Object getValueObject() {
        return this.getDataType().parse(this.value);
    }

    @Override
    public int compareTo(ParameterValueStruct o) {
        if (this.name.compareTo(o.getName()) == 0 && this.value.compareTo(o.getValue()) == 0 && this.type.compareTo(o.getType()) == 0) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.getValueObject()});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterValueStruct)) {
            return false;
        }
        ParameterValueStruct other = (ParameterValueStruct)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.getValueObject(), (Object)other.getValueObject());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("value", (Object)this.value).toString();
    }

    private static String normalizeType(String type) {
        return type.startsWith("xsd:") ? type : "xsd:" + type;
    }

    public static <T> ParameterValueStruct pvsOf(String name, DataType<T> dataType, T value) {
        return ParameterValueStruct.of(name, dataType, value);
    }

    public static <T> ParameterValueStruct of(String name, DataType<T> dataType, T value) {
        return new ParameterValueStruct(name, dataType.getValueType(), dataType.format(value));
    }
}

