/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.messaging.params.Notification;
import com.cogniance.acs.messaging.params.ParameterAttributeStruct;
import com.cogniance.acs.util.exception.ACSRuntimeException;
import com.cogniance.acs.util.soap.SOAPUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class GetParameterAttributesResponse
extends AbstractMessage
implements CPEResponse {
    private final List<ParameterAttributeStruct> parameterList = new ArrayList<ParameterAttributeStruct>();

    public GetParameterAttributesResponse() {
        super("GetParameterAttributesResponse");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.parameterList.clear();
        Iterator paramListIt = SOAPUtils.getChildElement((SOAPElement)body, "ParameterList").getChildElements(SOAP_FACTORY.createName("ParameterAttributeStruct"));
        while (paramListIt.hasNext()) {
            SOAPElement prm = (SOAPElement)paramListIt.next();
            String name = SOAPUtils.getChildElementValue(prm, Names.Name);
            Integer notificationCode = Integer.parseInt(SOAPUtils.getChildElementValue(prm, Names.Notification));
            Notification notification = Notification.byCode(notificationCode);
            ArrayList<String> accessList = new ArrayList<String>();
            SOAPElement accessListElement = SOAPUtils.getChildElement(prm, "AccessList");
            Iterator accessIt = accessListElement.getChildElements(SOAP_FACTORY.createName("string"));
            while (accessIt.hasNext()) {
                SOAPElement acc = (SOAPElement)accessIt.next();
                accessList.add(acc.getValue());
            }
            this.parameterList.add(new ParameterAttributeStruct(name, notification, accessList));
        }
    }

    public List<ParameterAttributeStruct> getParameterList() {
        return this.parameterList;
    }

    private static class Names {
        private static final Name Name;
        private static final Name Notification;

        private Names() {
        }

        static {
            try {
                Name = AbstractMessage.SOAP_FACTORY.createName("Name");
                Notification = AbstractMessage.SOAP_FACTORY.createName("Notification");
            }
            catch (SOAPException e) {
                throw new ACSRuntimeException("SOAP initialization failed.", new Object[]{e});
            }
        }
    }
}

