/*
 * Decompiled with CFR 0.152.
 */
package com.cogniance.acs.messaging;

import com.cogniance.acs.messaging.AbstractMessage;
import com.cogniance.acs.messaging.api.ACSResponse;
import com.cogniance.acs.messaging.api.CPEResponse;
import com.cogniance.acs.messaging.params.SetParameterValuesFault;
import com.cogniance.acs.util.exception.ACSRuntimeException;
import com.cogniance.acs.util.soap.SOAPUtils;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public class Fault
extends AbstractMessage
implements CPEResponse,
ACSResponse {
    public static final int NO_FAULT = 0;
    public static final int UNSUPPORTED_METHOD = 9000;
    public static final int REQUEST_DENIED = 9001;
    public static final int INTERNAL_ERROR = 9002;
    public static final int INVALID_ARGUMENTS = 9003;
    public static final int RESOURCES_EXCEEDED = 9004;
    public static final int INVALID_PARAMETER_NAME = 9005;
    public static final int INVALID_PARAMETER_TYPE = 9006;
    public static final int INVALID_PARAMETER_VALUE = 9007;
    public static final int READONLY_PARAMETER = 9008;
    public static final int NOTIFICATION_REQUEST_REJECTED = 9009;
    public static final int DOWNLOAD_FAILURE = 9010;
    public static final int UPLOAD_FAILURE = 9011;
    public static final int TRANSFER_AUTH_FAILURE = 9012;
    public static final int TRANSFER_INVALID_PROTOCOL = 9013;
    public static final int DOWNLOAD_UNABLE_TO_JOIN_MULTICAST_GROUP = 9014;
    public static final int DOWNLOAD_UNABLE_TO_CONTACT_SERVER = 9015;
    public static final int DOWNLOAD_UNABLE_TO_ACCESS_FILE = 9016;
    public static final int DOWNLOAD_UNABLE_TO_COMPLETE_DOWNLOAD = 9017;
    public static final int DOWNLOAD_FILE_CORRUPTED = 9018;
    public static final int DOWNLOAD_FILE_AUTH_FAILURE = 9019;
    public static final int SERVER_UNSUPPORTED_METHOD = 8000;
    public static final int SERVER_REQUEST_DENIED = 8001;
    public static final int SERVER_INTERNAL_ERROR = 8002;
    public static final int SERVER_INVALID_ARGUMENTS = 8003;
    public static final int SERVER_RESOURCES_EXCEEDED = 8004;
    public static final int SERVER_RETRY_REQUEST = 8005;
    private String faultCode;
    private String faultString;
    private Integer cwmpFaultCode;
    private String cwmpFaultString;
    private ArrayList<SetParameterValuesFault> parametersFault = new ArrayList();

    public Fault(int cwmpFaultCode, String cwmpFaultString) {
        this("Server", "CWMP fault", cwmpFaultCode, cwmpFaultString);
    }

    public Fault(String faultCode, String faultString, int cwmpFaultCode, String cwmpFaultString) {
        this();
        this.faultCode = faultCode;
        this.faultString = faultString;
        this.cwmpFaultCode = cwmpFaultCode;
        this.cwmpFaultString = cwmpFaultString;
    }

    public Fault() {
        super("Fault");
    }

    @Override
    protected void parseSOAPBody(SOAPBodyElement body) throws SOAPException {
        this.faultCode = SOAPUtils.getChildElementValue((SOAPElement)body, Names.faultcode);
        this.faultString = SOAPUtils.getChildElementValue((SOAPElement)body, Names.faultstring);
        SOAPElement detail = SOAPUtils.getChildElement((SOAPElement)body, Names.detail);
        SOAPElement cwmpFault = SOAPUtils.getChildElement(detail, Names.Fault);
        this.cwmpFaultCode = Integer.parseInt(SOAPUtils.getChildElementValue(cwmpFault, Names.FaultCode));
        this.cwmpFaultString = SOAPUtils.getChildElementValue(cwmpFault, Names.FaultString);
        Iterator spvfIter = cwmpFault.getChildElements(Names.SetParameterValuesFault);
        while (spvfIter.hasNext()) {
            SOAPElement spvf = (SOAPElement)spvfIter.next();
            String parameterName = SOAPUtils.getChildElementValue(spvf, Names.ParameterName);
            Integer faultCode = Integer.parseInt(SOAPUtils.getChildElementValue(spvf, Names.FaultCode));
            String faultString = SOAPUtils.getChildElementValue(spvf, Names.FaultString);
            this.parametersFault.add(new SetParameterValuesFault(parameterName, faultCode, faultString));
        }
    }

    @Override
    protected void fillSOAPBody(SOAPBodyElement body) throws SOAPException {
        body.addChildElement(Names.faultcode).setValue(this.faultCode);
        body.addChildElement(Names.faultstring).setValue(this.faultString);
        SOAPElement detail = body.addChildElement(Names.detail);
        SOAPElement cwmpFault = detail.addChildElement(Names.Fault);
        cwmpFault.addChildElement(Names.FaultCode).setValue(this.cwmpFaultCode.toString());
        cwmpFault.addChildElement(Names.FaultString).setValue((String)Objects.firstNonNull((Object)this.cwmpFaultString, (Object)""));
        for (SetParameterValuesFault parameterFault : this.parametersFault) {
            SOAPElement element = cwmpFault.addChildElement(Names.SetParameterValuesFault);
            element.addChildElement(Names.ParameterName).setValue(parameterFault.getParameterName());
            element.addChildElement(Names.FaultCode).setValue(parameterFault.getFaultCode().toString());
            element.addChildElement(Names.FaultString).setValue(parameterFault.getFaultString());
        }
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setFaultCode(String faultCode) {
        this.faultCode = faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setFaultString(String faultString) {
        this.faultString = faultString;
    }

    public Integer getCwmpFaultCode() {
        return this.cwmpFaultCode;
    }

    public void setCwmpFaultCode(Integer cwmpFaultCode) {
        this.cwmpFaultCode = cwmpFaultCode;
    }

    public String getCwmpFaultString() {
        return this.cwmpFaultString;
    }

    public void setCwmpFaultString(String cwmpFaultString) {
        this.cwmpFaultString = cwmpFaultString;
    }

    public ArrayList<SetParameterValuesFault> getParameterFaults() {
        return this.parametersFault;
    }

    public SetParameterValuesFault getParameterFault(String parameterName) {
        for (SetParameterValuesFault parameterFault : this.parametersFault) {
            if (!Objects.equal((Object)parameterFault.getParameterName(), (Object)parameterName)) continue;
            return parameterFault;
        }
        return null;
    }

    private static class Names {
        private static final Name faultcode;
        private static final Name faultstring;
        private static final Name detail;
        private static final Name Fault;
        private static final Name ParameterName;
        private static final Name FaultCode;
        private static final Name FaultString;
        private static final Name SetParameterValuesFault;

        private Names() {
        }

        static {
            try {
                faultcode = AbstractMessage.SOAP_FACTORY.createName("faultcode");
                faultstring = AbstractMessage.SOAP_FACTORY.createName("faultstring");
                detail = AbstractMessage.SOAP_FACTORY.createName("detail");
                Fault = AbstractMessage.SOAP_FACTORY.createName("Fault", "cwmp", "urn:dslforum-org:cwmp-1-0");
                ParameterName = AbstractMessage.SOAP_FACTORY.createName("ParameterName");
                FaultCode = AbstractMessage.SOAP_FACTORY.createName("FaultCode");
                FaultString = AbstractMessage.SOAP_FACTORY.createName("FaultString");
                SetParameterValuesFault = AbstractMessage.SOAP_FACTORY.createName("SetParameterValuesFault");
            }
            catch (SOAPException e) {
                throw new ACSRuntimeException("SOAP initialization failed.", new Object[]{e});
            }
        }
    }
}

