/****************************************************************************
* File:         $Workfile$
* Revision:     $Revision: 1.14 $
* Date:         $Date: 2006/01/23 07:26:48 $
*
* Overview:     
* Functions:
*
* Author:       Ravi Mantri
* 
* -- Metanoia Copyright Notice --
*
* (C) Copyright 2005 Metanoia, Inc. All rights reserved.
* 
* Metanoia reserves the right to change specifications without notice. 
* Copyright 2005 Metanoia, Inc. All rights reserved. Preliminary Data-Sheet 
* indicates this product is in design and the specification may change. 
* Electrical parametrics have not been analyzed and are not specified. Do not 
* use this data sheet as a design reference document. Please contact Metanoia 
* for a current data sheet that may be used as a design reference. All 
* contents of this document are protected by copyright law and may not be 
* reproduced without the express written consent of Metanoia, Inc. Metanoia, 
* the Metanoia logo, and combinations thereof are trademarks of Metanoia, Inc. 
* Other product names used in this publication are for identification purposes 
* only and may be trademarks or registered trademarks of their respective 
* companies. The contents of this document are provided in connection with 
* Metanoia, Inc. products. Metanoia, Inc. has made best efforts to ensure that 
* the information contained herein is accurate and reliable. However, Metanoia, 
* Inc. makes no warranties, express or implied, as to the accuracy or 
* completeness of the contents of this publication and is providing this 
* publication 'as is'. Metanoia, Inc. reserves the right to make changes to 
* specifications and product descriptions at any time without notice, and to 
* discontinue or make changes to its products at any time without notice. 
* Metanoia, Inc. does not assume any liability arising out of the application 
* or use of any product or circuit, and specifically disclaims any and all 
* liability, including without limitation special, consequential, or 
* incidental damages.
* 
****************************************************************************/
/**
 * \file 
 * \brief VDSL MIB define file
 */
#ifndef _VDSLMIB3_H_
#define _VDSLMIB3_H_


// %GROUP%
#define MT_MIB_VdslGroup									0
#define MT_MIB_VdslMCMGroup								1
#define MT_MIB_VdslMetanoiaGroup						2
#define MT_MIB_GroupMax									3


// %TABLE%
// MIB TABLES
// %VdslGroup%
#define MT_MIB_VdslLineTable							1
#define MT_MIB_VdslPhysTable							2
#define MT_MIB_VdslChanTable							3
#define MT_MIB_VdslPerfDataTable						4
#define MT_MIB_VdslPerfIntervalTable					5
#define MT_MIB_VdslPerf1DayIntervalTable				6
#define MT_MIB_VdslChanPerfDataTable					7
#define MT_MIB_VdslChanIntervalTable					8
#define MT_MIB_VdslChan1DayIntervalTable				9
#define MT_MIB_VdslLineConfProfileTable				10
#define MT_MIB_VdslLineAlarmConfProfileTable			11
#define MT_MIB_VdslGroupTableMax						11

// %ENTRIES%
// %VdslLineTable%
#define MT_MIB_VdslLineCoding							1
#define MT_MIB_VdslLineType								2
#define MT_MIB_VdslLineConfProfile						3
#define MT_MIB_VdslLineAlarmConfProfile				4

// %VdslPhysTable%
#define MT_MIB_VdslPhysSide								1
#define MT_MIB_VdslPhysInvSerialNumber					2
#define MT_MIB_VdslPhysInvVendorID						3
#define MT_MIB_VdslPhysInvVersionNumber				4
#define MT_MIB_VdslPhysCurrSnrMgn						5
#define MT_MIB_VdslPhysCurrAtn							6
#define MT_MIB_VdslPhysCurrStatus						7
#define MT_MIB_VdslPhysCurrOutputPwr					8
#define MT_MIB_VdslPhysCurrAttainableRate				9
#define MT_MIB_VdslPhysCurrLineRate					10

// %VdslChanTable%
#define MT_MIB_VdslChanInterleaveDelay					1
#define MT_MIB_VdslChanCrcBlockLength					2
#define MT_MIB_VdslChanCurrTxRate						3
#define MT_MIB_VdslChanCurrTxSlowBurstProtect			4
#define MT_MIB_VdslChanCurrTxFastFec					5

// %VdslPerfDataTable%
#define MT_MIB_VdslPerfDataValidIntervals				1
#define MT_MIB_VdslPerfDataInvalidIntervals			2
#define MT_MIB_VdslPerfDataLofs							3
#define MT_MIB_VdslPerfDataLoss							4
#define MT_MIB_VdslPerfDataLprs							5
#define MT_MIB_VdslPerfDataLols							6
#define MT_MIB_VdslPerfDataESs							7
#define MT_MIB_VdslPerfDataSESs							8
#define MT_MIB_VdslPerfDataUASs							9
#define MT_MIB_VdslPerfDataInits						10
#define MT_MIB_VdslPerfDataCurr15MinTimeElapsed		11
#define MT_MIB_VdslPerfDataCurr15MinLofs				12
#define MT_MIB_VdslPerfDataCurr15MinLoss				13
#define MT_MIB_VdslPerfDataCurr15MinLprs				14
#define MT_MIB_VdslPerfDataCurr15MinLols				15
#define MT_MIB_VdslPerfDataCurr15MinESs				16
#define MT_MIB_VdslPerfDataCurr15MinSESs				17
#define MT_MIB_VdslPerfDataCurr15MinUASs				18
#define MT_MIB_VdslPerfDataCurr15MinInits				19
#define MT_MIB_VdslPerfData1DayValidIntervals			20
#define MT_MIB_VdslPerfData1DayInvalidIntervals		21
#define MT_MIB_VdslPerfDataCurr1DayTimeElapsed		22
#define MT_MIB_VdslPerfDataCurr1DayLofs				23
#define MT_MIB_VdslPerfDataCurr1DayLoss				24
#define MT_MIB_VdslPerfDataCurr1DayLprs				25
#define MT_MIB_VdslPerfDataCurr1DayLols				26
#define MT_MIB_VdslPerfDataCurr1DayESs					27
#define MT_MIB_VdslPerfDataCurr1DaySESs				28
#define MT_MIB_VdslPerfDataCurr1DayUASs				29
#define MT_MIB_VdslPerfDataCurr1DayInits				30

// %VdslPerfIntervalTable%
#define MT_MIB_VdslPerfIntervalNumber					1
#define MT_MIB_VdslPerfIntervalLofs					2
#define MT_MIB_VdslPerfIntervalLoss					3
#define MT_MIB_VdslPerfIntervalLprs					4
#define MT_MIB_VdslPerfIntervalLols					5
#define MT_MIB_VdslPerfIntervalESs						6
#define MT_MIB_VdslPerfIntervalSESs					7
#define MT_MIB_VdslPerfIntervalUASs					8
#define MT_MIB_VdslPerfIntervalInits					9

// %VdslPerf1DayIntervalTable%
#define MT_MIB_VdslPerf1DayIntervalNumber				1
#define MT_MIB_VdslPerf1DayIntervalMoniSecs			2
#define MT_MIB_VdslPerf1DayIntervalLofs				3
#define MT_MIB_VdslPerf1DayIntervalLoss				4
#define MT_MIB_VdslPerf1DayIntervalLprs				5
#define MT_MIB_VdslPerf1DayIntervalLols				6
#define MT_MIB_VdslPerf1DayIntervalESs					7
#define MT_MIB_VdslPerf1DayIntervalSESs				8
#define MT_MIB_VdslPerf1DayIntervalUASs				9
#define MT_MIB_VdslPerf1DayIntervalInits				10

// %VdslChanPerfDataTable%
#define MT_MIB_VdslChanValidIntervals					1
#define MT_MIB_VdslChanInvalidIntervals				2
#define MT_MIB_VdslChanFixedOctets						3
#define MT_MIB_VdslChanBadBlks							4
#define MT_MIB_VdslChanCurr15MinTimeElapsed			5
#define MT_MIB_VdslChanCurr15MinFixedOctets			6
#define MT_MIB_VdslChanCurr15MinBadBlks				7
#define MT_MIB_VdslChan1DayValidIntervals				8
#define MT_MIB_VdslChan1DayInvalidIntervals			9
#define MT_MIB_VdslChanCurr1DayTimeElapsed			10
#define MT_MIB_VdslChanCurr1DayFixedOctets			11
#define MT_MIB_VdslChanCurr1DayBadBlks					12

// %VdslChanIntervalTable%
#define MT_MIB_VdslChanIntervalNumber					1
#define MT_MIB_VdslChanIntervalFixedOctets			2
#define MT_MIB_VdslChanIntervalBadBlks					3

// %VdslChan1DayIntervalTable%
#define MT_MIB_VdslChan1DayIntervalNumber				1
#define MT_MIB_VdslChan1DayIntervalMoniSecs			2
#define MT_MIB_VdslChan1DayIntervalFixedOctets		3
#define MT_MIB_VdslChan1DayIntervalBadBlks			4

// %VdslLineConfProfileTable%
#define MT_MIB_VdslLineConfProfileName					1
#define MT_MIB_VdslLineConfDownRateMode				2
#define MT_MIB_VdslLineConfUpRateMode					3
#define MT_MIB_VdslLineConfDownMaxPwr					4
#define MT_MIB_VdslLineConfUpMaxPwr					5
#define MT_MIB_VdslLineConfDownMaxSnrMgn				6
#define MT_MIB_VdslLineConfDownMinSnrMgn				7
#define MT_MIB_VdslLineConfDownTargetSnrMgn			8
#define MT_MIB_VdslLineConfUpMaxSnrMgn					9
#define MT_MIB_VdslLineConfUpMinSnrMgn					10
#define MT_MIB_VdslLineConfUpTargetSnrMgn				11
#define MT_MIB_VdslLineConfDownFastMaxDataRate		12
#define MT_MIB_VdslLineConfDownFastMinDataRate		13
#define MT_MIB_VdslLineConfDownSlowMaxDataRate		14
#define MT_MIB_VdslLineConfDownSlowMinDataRate		15
#define MT_MIB_VdslLineConfUpFastMaxDataRate			16
#define MT_MIB_VdslLineConfUpFastMinDataRate			17
#define MT_MIB_VdslLineConfUpSlowMaxDataRate			18
#define MT_MIB_VdslLineConfUpSlowMinDataRate			19
#define MT_MIB_VdslLineConfDownRateRatio				20
#define MT_MIB_VdslLineConfUpRateRatio					21
#define MT_MIB_VdslLineConfDownMaxInterDelay			22
#define MT_MIB_VdslLineConfUpMaxInterDelay			23
#define MT_MIB_VdslLineConfDownPboControl				24
#define MT_MIB_VdslLineConfUpPboControl				25
#define MT_MIB_VdslLineConfDownPboLevel				26
#define MT_MIB_VdslLineConfUpPboLevel					27
#define MT_MIB_VdslLineConfDeploymentScenario			28
#define MT_MIB_VdslLineConfAdslPresence				29
#define MT_MIB_VdslLineConfApplicableStandard			30
#define MT_MIB_VdslLineConfBandPlan					31
#define MT_MIB_VdslLineConfBandPlanFx					32
#define MT_MIB_VdslLineConfBandOptUsage				33
#define MT_MIB_VdslLineConfUpPsdTemplate				34
#define MT_MIB_VdslLineConfDownPsdTemplate			35
#define MT_MIB_VdslLineConfHamBandMask					36
#define MT_MIB_VdslLineConfCustomNotch1Start			37
#define MT_MIB_VdslLineConfCustomNotch1Stop			38
#define MT_MIB_VdslLineConfCustomNotch2Start			39
#define MT_MIB_VdslLineConfCustomNotch2Stop			40
#define MT_MIB_VdslLineConfDownTargetSlowBurst		41
#define MT_MIB_VdslLineConfUpTargetSlowBurst			42
#define MT_MIB_VdslLineConfDownMaxFastFec				43
#define MT_MIB_VdslLineConfUpMaxFastFec				44
#define MT_MIB_VdslLineConfLineType					45
#define MT_MIB_VdslLineConfProfRowStatus				46

// %VdslLineAlarmConfProfileTable%
#define MT_MIB_VdslLineAlarmConfProfileName			1
#define MT_MIB_VdslLineAlarmConfThresh15MinLofs		2
#define MT_MIB_VdslLineAlarmConfThresh15MinLoss		3
#define MT_MIB_VdslLineAlarmConfThresh15MinLprs		4
#define MT_MIB_VdslLineAlarmConfThresh15MinLols		5
#define MT_MIB_VdslLineAlarmConfThresh15MinESs		6
#define MT_MIB_VdslLineAlarmConfThresh15MinSESs		7
#define MT_MIB_VdslLineAlarmConfThresh15MinUASs		8
#define MT_MIB_VdslLineAlarmConfInitFailure			9
#define MT_MIB_VdslLineAlarmConfProfRowStatus			10



// MIB TABLES
// %TABLE%
// %VdslMCMGroup%
#define MT_MIB_VdslLineMCMConfProfileTable			1
#define MT_MIB_VdslLineMCMConfProfileTxBandTable		2
#define MT_MIB_VdslLineMCMConfProfileRxBandTable		3
#define MT_MIB_VdslLineMCMConfProfileTxPSDTable		4
#define MT_MIB_VdslLineMCMConfProfileMaxTxPSDTable	5
#define MT_MIB_VdslLineMCMConfProfileMaxRxPSDTable	6
#define MT_MIB_VdslMCMGroupTableMax					6

// MIB TABLE ENTRIES
// %ENTRYS%
// %VdslLineMCMConfProfileTable%
#define MT_MIB_VdslLineMCMConfProfileTxWindowLength	1
#define MT_MIB_VdslLineMCMConfProfileRowStatus		2

// %VdslLineMCMConfProfileTxBandTable%
#define MT_MIB_VdslLineMCMConfProfileTxBandNumber	1
#define MT_MIB_VdslLineMCMConfProfileTxBandStart		2
#define MT_MIB_VdslLineMCMConfProfileTxBandStop		3
#define MT_MIB_VdslLineMCMConfProfileTxBandRowStatus	4

// %VdslLineMCMConfProfileRxBandTable%
#define MT_MIB_VdslLineMCMConfProfileRxBandNumber	1
#define MT_MIB_VdslLineMCMConfProfileRxBandStart		2
#define MT_MIB_VdslLineMCMConfProfileRxBandStop		3
#define MT_MIB_VdslLineMCMConfProfileRxBandRowStatus	4

// %VdslLineMCMConfProfileTxPSDTable%
#define MT_MIB_VdslLineMCMConfProfileTxPSDNumber		1
#define MT_MIB_VdslLineMCMConfProfileTxPSDTone		2
#define MT_MIB_VdslLineMCMConfProfileTxPSDPSD			3
#define MT_MIB_VdslLineMCMConfProfileTxPSDRowStatus	4

// %VdslLineMCMConfProfileMaxTxPSDTable%
#define MT_MIB_VdslLineMCMConfProfileMaxTxPSDNumber	1
#define MT_MIB_VdslLineMCMConfProfileMaxTxPSDTone	2
#define MT_MIB_VdslLineMCMConfProfileMaxTxPSDPSD		3
#define MT_MIB_VdslLineMCMConfProfileMaxTxPSDRowStatus	4

// %VdslLineMCMConfProfileMaxRxPSDTable%
#define MT_MIB_VdslLineMCMConfProfileMaxRxPSDNumber	1
#define MT_MIB_VdslLineMCMConfProfileMaxRxPSDTone	2
#define MT_MIB_VdslLineMCMConfProfileMaxRxPSDPSD		3
#define MT_MIB_VdslLineMCMConfProfileMaxRxPSDRowStatus	4

// %VdslMetanoiaGroup%
#define MT_MIB_VdslMetanoiaTable						1
#define MT_MIB_VdslMetanoiaTable2						2
#define MT_MIB_VdslMetanoiaT3							3  // Layer 3
#define MT_MIB_VdslMetanoiaGroupTableMax				3
// %VdslMetanoiaTable%
#define MT_MIB_VdslFirmwareVer						1
#define MT_MIB_VdslFirmwareDate							2
#define MT_MIB_VdslFirmwareTime						3
#define MT_MIB_VdslBoardType							4
#define MT_MIB_VdslTerminal						5  // 0=>OT,1=>RT
#define MT_MIB_MetanoiaSignature							6
#define MT_MIB_vdslNotificationGroup        7
#define MT_MIB_VdslLineConfMutMode					8
#define MT_MIB_VdslLineConfUtpFastChUs					9
#define MT_MIB_VdslLineConfUtpSlowChUs					10
#define MT_MIB_VdslLineConfUtpFastChDs					11
#define MT_MIB_VdslLineConfUtpSlowChDs					12
#define MT_MIB_VdslLineConfUtpIdlePrm0					13
#define MT_MIB_VdslLineConfUtpIdlePrm1					14
#define MT_MIB_VdslLineConfUtpTxWmk					15
#define MT_MIB_VdslLineConfUtpRxWmk					16
#define MT_MIB_VdslLineConfUtpCfgReg					17
#define MT_MIB_VdslLineConfUtpCtlReg					18
#define MT_MIB_VdslLineConfMiiCtlInitReg				19
#define MT_MIB_VdslLineConfMiiCfgInitReg				20
#define MT_MIB_VdslLineConfMiiTxThresh					21
#define MT_MIB_VdslLineConfMiiCtlReg					22
#define MT_MIB_VdslLineConfUtpCtlSyncReg				23
#define MT_MIB_VdslLineConfMiiCfgReg					24
#define MT_MIB_VdslLineConfXmiiCfg					25
#define MT_MIB_VdslLineDiagInit						26
#define MT_MIB_VdslLineDiagInitD					27
#define MT_MIB_VdslLineDiagInitDD					28
#define MT_MIB_VdslLineDiagTrn						29
#define MT_MIB_VdslLineDiagTrnD						30
#define MT_MIB_VdslLineDiagTrnDD					31
#define MT_MIB_VdslLineDiagSt						32
#define MT_MIB_VdslLineDiagStD						33
#define MT_MIB_VdslLineDiagStDD						34
#define MT_MIB_VdslLineMaxBits						35
#define MT_MIB_VdslLineByOrigCnt					36
#define MT_MIB_VdslLineTime250ms					37
#define MT_MIB_VdslLineTime250msD					38
#define MT_MIB_VdslLineTime250msDD				39
#define MT_MIB_VdslLinePauseFrmCntr					40
#define MT_MIB_VdslLineDiagSt2						41
#define MT_MIB_VdslLineDiagSt2D						42
#define MT_MIB_VdslLineDiagSt2DD					43
#define MT_MIB_vdslLineFgndCntr						44	
#define MT_MIB_VdslLineConfBoostLevel			45
#define MT_MIB_vdslLineConfUS0TxLevel				46
#define MT_MIB_vdslMetanoiaRxPgaRefOt				47
#define MT_MIB_vdslMetanoiaRxPgaRefRt				48
#define MT_MIB_vdslTwConfig								49
#define MT_MIB_vdslTwConfig2								50

#define MT_MIB_CompCapaBitTst1				51
#define MT_MIB_CompCapaBitTst2				52
#define MT_MIB_EndCompCapaBitTst			53
#define MT_MIB_CompenCapaAmp1				54
#define MT_MIB_CompenCapaAmp2				55
#define MT_MIB_CompenCapaDelta1			56
#define MT_MIB_CompenCapaDelta2			57
#define MT_MIB_vdslMetanoiaRxByteCntrHi	58
#define MT_MIB_vdslMetanoiaRxByteCntrLo	59
#define MT_MIB_vdslMetanoiaTxByteCntrHi	60
#define MT_MIB_vdslMetanoiaTxByteCntrLo	61



// %VdslMetanoiaTable2%
#define MT_MIB_vdslFirmwareVer						1
#define MT_MIB_vdslFirmwareDate						2
#define MT_MIB_vdslFirmwareTime						3
#define MT_MIB_vdslBoardType							4
#define MT_MIB_vdslTerminal							5
#define MT_MIB_vdslMetanoiaSignature					6
#define MT_MIB_vdslMetanoiaUsDataRatio					7
#define MT_MIB_vdslMetanoiaVcxo						8

// %VdslMetanoiaT3%
#define MT_MIB_VdslPhysCurrStatusL3					1

// %end%	
// VDSL MIB PARAM DEFINES

// ifType
#define MT_MIB_IFTYPE_VDSL								97
#define MT_MIB_IFTYPE_INTERLEAVED						124
#define MT_MIB_IFTYPE_FAST								125

// MT_MIB_VdslLineCoding
#define MT_MIB_OTHER										1
#define MT_MIB_MCM										2
#define MT_MIB_SCM										3

// MT_MIB_VdslLineType
#define MT_MIB_noChannel									1
#define MT_MIB_fastOnly									2
#define MT_MIB_interleavedOnly							3
#define MT_MIB_fastOrInterleaved						4
#define MT_MIB_fastAndInterleaved						5

// MT_MIB_VdslPhysSide
#define MT_MIB_VTUC										1
#define MT_MIB_VTUR										2

// MT_MIB_VdslPhysCurrStatus
#define MT_MIB_noDefect									0
#define MT_MIB_lossOfFraming							1
#define MT_MIB_lossOfSignal								2
#define MT_MIB_lossOfPower								3
#define MT_MIB_lossOfSignalQuality						4
#define MT_MIB_lossOfLink								5
#define MT_MIB_dataInitFailure							6
#define MT_MIB_configInitFailure						7
#define MT_MIB_protocolInitFailure						8
#define MT_MIB_noPeerVtuPresent							9

// MT_MIB_VdslLineConfDownRateMode, MT_MIB_VdslLineConfUpRateMode
#define MT_MIB_manual									1
#define MT_MIB_adaptAtInit								2

// MT_MIB_VdslLineConfDownPboControl, MT_MIB_VdslLineConfUpPboControl
#define MT_MIB_disabled									1
#define MT_MIB_auto										2
//#define MT_MIB_manual									3
#define MT_MIB_manual2									3

// MT_MIB_VdslLineConfDeploymentScenario
#define MT_MIB_fttCab									1
#define MT_MIB_fttEx										2
#define MT_MIB_ds_other									3

// MT_MIB_VdslLineConfAdslPresence
#define MT_MIB_none										1
#define MT_MIB_adslOverPots								2
#define MT_MIB_adslOverISDN								3

// MT_MIB_VdslLineConfApplicableStandard
#define MT_MIB_ansi										1
#define MT_MIB_etsi										2
#define MT_MIB_itu										3
#define MT_MIB_as_other									4

// MT_MIB_VdslLineConfBandPlan
#define MT_MIB_bandPlan997								1
#define MT_MIB_bandPlan998								2
#define MT_MIB_bandPlanFx								3
#define MT_MIB_bp_other									4

// MT_MIB_VdslLineConfBandOptUsage
#define MT_MIB_unused									1
#define MT_MIB_upstream									2
#define MT_MIB_downstream								3

// MT_MIB_VdslLineConfUpPsdTemplate, MT_MIB_VdslLineConfDownPsdTemplate
#define MT_MIB_templateMask1							1
#define MT_MIB_templateMask2							2

// MT_MIB_VdslLineConfHamBandMask
#define MT_MIB_customNotch1								0
#define MT_MIB_customNotch2								1
#define MT_MIB_amateurBand30m							2
#define MT_MIB_amateurBand40m							3
#define MT_MIB_amateurBand80m							4
#define MT_MIB_amateurBand160m							5

// MT_MIB_VdslNotifications - bit fields
#define MT_MIB_VdslPerfLofsThreshNotification			0
#define MT_MIB_VdslPerfLossThreshNotification			1
#define MT_MIB_VdslPerfLprsThreshNotification			2
#define	MT_MIB_VdslPerfLolsThreshNotification		3
#define MT_MIB_VdslPerfESsThreshNotification			4
#define MT_MIB_VdslPerfSESsThreshNotification			5
#define MT_MIB_VdslPerfUASsThreshNotification			6
#define MT_MIB_VdslDownMaxSnrMgnNotification			7
#define MT_MIB_VdslDownMinSnrMgnNotification			8
#define MT_MIB_VdslUpMaxSnrMgnNotification			9
#define MT_MIB_VdslUpMinSnrMgnNotification			10
#define MT_MIB_VdslInitFailureNotification			11

//


#endif	//_VDSLMIB3_H_
