@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  GDServer startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

@rem Add default JVM options here. You can also use JAVA_OPTS and GD_SERVER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windowz variants

if not "%OS%" == "Windows_NT" goto win9xME_args
if "%@eval[2+2]" == "4" goto 4NT_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*
goto execute

:4NT_args
@rem Get arguments from the 4NT Shell from JP Software
set CMD_LINE_ARGS=%$

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\GDServer.jar;%APP_HOME%\lib\commons-lang3-3.3.2.jar;%APP_HOME%\lib\commons-codec-1.4.jar;%APP_HOME%\lib\infinispan-core-7.1.1.Final.jar;%APP_HOME%\lib\log4j-1.2.16.jar;%APP_HOME%\lib\gson-2.2.4.jar;%APP_HOME%\lib\spring-context-support-3.2.5.RELEASE.jar;%APP_HOME%\lib\hazelcast-3.2.3.jar;%APP_HOME%\lib\httpclient-4.1.2.jar;%APP_HOME%\lib\jackson-mapper-asl-1.9.13.jar;%APP_HOME%\lib\javax.mail-api-1.5.5.jar;%APP_HOME%\lib\javax.servlet-api-3.0.1.jar;%APP_HOME%\lib\jetty-all-server-8.1.13.v20130916.jar;%APP_HOME%\lib\lombok-1.16.6.jar;%APP_HOME%\lib\json-simple-1.1.1.jar;%APP_HOME%\lib\dnsjava-2.0.8.jar;%APP_HOME%\lib\eagledns-fork-3.0.1.Final.jar;%APP_HOME%\lib\CoDec-build17-jdk13.jar;%APP_HOME%\lib\FlexiCoreProvider-1.7p1.signed.jar;%APP_HOME%\lib\FlexiECProvider-1.7p1.signed.jar;%APP_HOME%\lib\jersey-spring-1.17.1.jar;%APP_HOME%\lib\spring-security-core-3.2.5.RELEASE.jar;%APP_HOME%\lib\spring-security-config-3.2.5.RELEASE.jar;%APP_HOME%\lib\spring-security-web-3.2.5.RELEASE.jar;%APP_HOME%\lib\aspectjweaver-1.7.2.jar;%APP_HOME%\lib\spring-aspects-3.2.5.RELEASE.jar;%APP_HOME%\lib\commons-dbcp-1.4.jar;%APP_HOME%\lib\infinispan-cli-interpreter-7.1.1.Final.jar;%APP_HOME%\lib\infinispan-commons-7.1.1.Final.jar;%APP_HOME%\lib\infinispan-server-core-7.1.1.Final.jar;%APP_HOME%\lib\infinispan-spring-7.1.1.Final.jar;%APP_HOME%\lib\jgroups-3.6.1.Final.jar;%APP_HOME%\lib\jackson-core-asl-1.9.13.jar;%APP_HOME%\lib\jackson-jaxrs-1.9.13.jar;%APP_HOME%\lib\jackson-xc-1.9.13.jar;%APP_HOME%\lib\jersey-json-1.19.1.jar;%APP_HOME%\lib\jersey-servlet-1.19.1.jar;%APP_HOME%\lib\jboss-transaction-api_1.1_spec-1.0.1.Final.jar;%APP_HOME%\lib\jboss-marshalling-osgi-1.4.4.Final.jar;%APP_HOME%\lib\jboss-logging-3.1.2.GA.jar;%APP_HOME%\lib\aopalliance-1.0.jar;%APP_HOME%\lib\annotations-1.3.2.jar;%APP_HOME%\lib\httpcore-4.1.2.jar;%APP_HOME%\lib\javax.servlet-3.0.0.v201112011016.jar;%APP_HOME%\lib\javax.security.auth.message-1.0.0.v201108011116.jar;%APP_HOME%\lib\javax.mail.glassfish-1.4.1.v201005082020.jar;%APP_HOME%\lib\javax.activation-1.1.0.v201105071233.jar;%APP_HOME%\lib\javax.annotation-1.1.0.v201108011116.jar;%APP_HOME%\lib\junit-4.10.jar;%APP_HOME%\lib\dnsjava-2.0.8.jar;%APP_HOME%\lib\antlr-runtime-3.4.jar;%APP_HOME%\lib\netty-all-4.0.20.Final.jar;%APP_HOME%\lib\scala-library-2.11.2.jar;%APP_HOME%\lib\jettison-1.1.jar;%APP_HOME%\lib\jaxb-impl-2.2.3-1.jar;%APP_HOME%\lib\hamcrest-core-1.1.jar;%APP_HOME%\lib\stringtemplate-3.2.1.jar;%APP_HOME%\lib\antlr-2.7.7.jar;%APP_HOME%\lib\jaxb-api-2.2.2.jar;%APP_HOME%\lib\stax-api-1.0-2.jar;%APP_HOME%\lib\activation-1.1.jar;%APP_HOME%\lib\jersey-server-1.19.1.jar;%APP_HOME%\lib\spring-context-3.2.9.RELEASE.jar;%APP_HOME%\lib\spring-web-3.2.8.RELEASE.jar;%APP_HOME%\lib\spring-aop-3.2.9.RELEASE.jar;%APP_HOME%\lib\commons-pool-1.6.jar;%APP_HOME%\lib\commons-logging-1.1.3.jar;%APP_HOME%\lib\jersey-core-1.19.1.jar;%APP_HOME%\lib\jsr311-api-1.1.1.jar;%APP_HOME%\lib\spring-beans-3.2.9.RELEASE.jar;%APP_HOME%\lib\spring-core-3.2.9.RELEASE.jar;%APP_HOME%\lib\spring-expression-3.2.9.RELEASE.jar

@rem Execute GDServer
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %GD_SERVER_OPTS%  -classpath "%CLASSPATH%" com.vestiacom.gdserver.Main %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable GD_SERVER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%GD_SERVER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
