/*
 * Decompiled with CFR 0.152.
 */
package de.flexiprovider.ec.asn1;

import codec.asn1.ASN1Integer;
import codec.asn1.ASN1OctetString;
import codec.asn1.ASN1Sequence;
import de.flexiprovider.common.math.FlexiBigInt;
import de.flexiprovider.common.util.ASN1Tools;
import de.flexiprovider.ec.asn1.Curve;
import de.flexiprovider.ec.asn1.FieldId;
import java.util.ArrayList;

public class ECDomainParameters
extends ASN1Sequence {
    private static final ASN1Integer version = new ASN1Integer(1);

    public ECDomainParameters() {
        super(6);
        ((ArrayList)((Object)this)).add(version);
        ((ArrayList)((Object)this)).add(new FieldId());
        ((ArrayList)((Object)this)).add(new Curve());
        ((ArrayList)((Object)this)).add(new ASN1OctetString());
        ((ArrayList)((Object)this)).add(new ASN1Integer());
        ASN1Integer cofactor = new ASN1Integer();
        cofactor.setOptional(true);
        ((ArrayList)((Object)this)).add(cofactor);
    }

    public ECDomainParameters(FieldId fieldId, Curve curve, ASN1OctetString basePoint, ASN1Integer order, ASN1Integer cofactor) {
        super(6);
        ((ArrayList)((Object)this)).add(version);
        ((ArrayList)((Object)this)).add(fieldId);
        ((ArrayList)((Object)this)).add(curve);
        ((ArrayList)((Object)this)).add(basePoint);
        ((ArrayList)((Object)this)).add(order);
        if (cofactor != null) {
            ((ArrayList)((Object)this)).add(cofactor);
        }
    }

    public FieldId getFieldId() {
        return (FieldId)((Object)((ArrayList)((Object)this)).get(1));
    }

    public byte[] getA() {
        return ((Curve)((Object)((ArrayList)((Object)this)).get(2))).getA();
    }

    public byte[] getB() {
        return ((Curve)((Object)((ArrayList)((Object)this)).get(2))).getB();
    }

    public byte[] getG() {
        return ((ASN1OctetString)((ArrayList)((Object)this)).get(3)).getByteArray();
    }

    public FlexiBigInt getR() {
        return ASN1Tools.getFlexiBigInt((ASN1Integer)((ArrayList)((Object)this)).get(4));
    }

    public int getK() {
        ASN1Integer asn1Integer = (ASN1Integer)((ArrayList)((Object)this)).get(5);
        if (asn1Integer != null) {
            int value = ASN1Tools.getFlexiBigInt(asn1Integer).intValue();
            if (value == 0) {
                return 1;
            }
            return value;
        }
        return 1;
    }
}

