/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.upnp;

import com.vestiacom.gdserver.rest.response.SetUpUpnpForwardingResponse;
import com.vestiacom.gdserver.service.impl.HttpProxySessions;
import com.vestiacom.gdserver.service.impl.SetUpForwardingException;
import homemonitor.Application;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.SenderInterface;
import homemonitor.upnp.UPnPAppCallback;
import homemonitor.upnp.UPnPAppHandler;
import homemonitor.upnp.UPnPAppTransmitter;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class UPnPApp
extends Application
implements SenderInterface {
    private static Logger log = Logger.getLogger(UPnPApp.class);
    private Map<Long, Handle> handles = new HashMap<Long, Handle>();
    private GatewayDeviceConnectionInterface gdc = null;
    private HttpClient client = null;
    private Callback callback;
    private boolean skipVerification = false;
    private HttpProxySessions httpProxySessions;
    private ThreadPoolTaskExecutor taskExecutor;

    public void registerCallback(Callback callback) {
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionDisconnected(String deviceId, Long sessionId) {
        Map<Long, Handle> map = this.handles;
        synchronized (map) {
            this.handles.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(String deviceId, int tag, long serviceId, byte[] data) {
        Handle handle = null;
        Map<Long, Handle> map = this.handles;
        synchronized (map) {
            handle = this.handles.get(serviceId);
        }
        if (handle == null) {
            log.error((Object)"Got data with invalid session id!");
        } else if (handle.getHandler().receivedData(tag, data)) {
            this.closeSession(serviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(long serviceId) {
        Map<Long, Handle> map = this.handles;
        synchronized (map) {
            this.handles.remove(serviceId);
        }
        this.gdc.destroySession(serviceId);
        this.sessionDelete(serviceId);
    }

    public UPnPApp() {
    }

    public UPnPApp(GatewayDeviceConnectionInterface gdc, HttpClient client, boolean skipVerification, HttpProxySessions httpProxySessions, ThreadPoolTaskExecutor taskExecutor) {
        this.gdc = gdc;
        this.client = client;
        this.skipVerification = skipVerification;
        this.httpProxySessions = httpProxySessions;
        this.taskExecutor = taskExecutor;
    }

    void sendData(Handle handle, int tag, byte[] data) throws UPnPAppTransmitter.SendException {
        if (this.gdc.send(tag, handle.getSessionId(), data) != GDErrorCode.NoError) {
            throw new UPnPAppTransmitter.SendException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setupForwarding(Handle handle, short port) {
        long sessionId = this.gdc.createSession(handle.getId(), this);
        if (sessionId == 0L) {
            return false;
        }
        try {
            handle.setSessionId(sessionId);
            handle.getHandler().setupForwarding(port);
            Map<Long, Handle> map = this.handles;
            synchronized (map) {
                this.handles.put(sessionId, handle);
            }
            this.sessionAdd(handle.getId(), sessionId);
            return true;
        }
        catch (UPnPAppTransmitter.SendException e) {
            this.gdc.destroySession(sessionId);
            return false;
        }
    }

    public boolean setupForwarding(String id, short port) {
        Handle handle = new Handle(this.callback);
        handle.setHandler(new UPnPAppHandler(handle, handle, this.client, id, this.gdc.findById((String)id).publicIpAddress, this.skipVerification, this.httpProxySessions, this.taskExecutor));
        return handle.setupForwarding(port);
    }

    public boolean forwardingWorks(String id, short port) {
        GatewayDevice gatewayDevice = this.gdc.findById(id);
        if (gatewayDevice == null) {
            throw new SetUpForwardingException(SetUpUpnpForwardingResponse.ErrorCode.DEVICE_NOT_CONNECTED);
        }
        Handle handle = new Handle(null);
        handle.setHandler(new UPnPAppHandler(handle, handle, this.client, id, gatewayDevice.publicIpAddress, this.skipVerification, this.httpProxySessions, this.taskExecutor));
        return handle.forwardingWorks(id, port);
    }

    public class Handle
    implements UPnPAppCallback,
    UPnPAppTransmitter {
        private UPnPAppHandler handler;
        private Callback callback;
        private long sessionId;

        Handle(Callback callback) {
            this.callback = callback;
        }

        UPnPAppHandler getHandler() {
            return this.handler;
        }

        void setHandler(UPnPAppHandler handler) {
            this.handler = handler;
        }

        Callback getCallback() {
            return this.callback;
        }

        long getSessionId() {
            return this.sessionId;
        }

        void setSessionId(long session_id) {
            this.sessionId = session_id;
        }

        public int getStatusCode() {
            return this.handler.getStatusCode();
        }

        public boolean getForwardStatus() {
            return this.handler.getForwardStatus();
        }

        public short getTestedPort() {
            return this.handler.getTestedPort();
        }

        public String getLocalIp() {
            return this.handler.getLocalIp();
        }

        public String getId() {
            return this.handler.getId();
        }

        @Override
        public void forwardingStatus(UPnPAppHandler upnp_app, boolean works) {
            log.debug((Object)("forwarding status: id=" + this.getId() + ", localIp=" + this.getLocalIp() + ", statusCode=" + this.getStatusCode() + ", works=" + works));
            this.callback.forwardingStatus(this.getId(), this.getLocalIp(), this.getStatusCode(), works);
        }

        public boolean setupForwarding(short port) {
            return UPnPApp.this.setupForwarding(this, port);
        }

        public boolean forwardingWorks(String id, short port) {
            return this.handler.forwardingWorks(id, port);
        }

        @Override
        public void sendData(UPnPAppHandler handler, int tag, byte[] data) throws UPnPAppTransmitter.SendException {
            UPnPApp.this.sendData(this, tag, data);
        }

        @Override
        public void closeSession() {
            UPnPApp.this.closeSession(this.getSessionId());
        }
    }

    public static interface Callback {
        public void forwardingStatus(String var1, String var2, int var3, boolean var4);
    }
}

