/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.execcmd;

import homemonitor.GatewayDeviceConnection;
import homemonitor.execcmd.CmdResult;
import homemonitor.execcmd.ExecCmdApp;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExecCmdService
implements ExecCmdApp.Callback {
    private static Logger log = Logger.getLogger(ExecCmdService.class);
    private GatewayDeviceConnection gatewayDeviceConnection;
    private CountDownLatch latch;
    private long timeout = 20L;
    private CmdResult result;

    @Autowired
    @Required
    public void setGatewayDeviceConnection(GatewayDeviceConnection gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public CmdResult executeCommand(String deviceId, String command) {
        log.debug((Object)("start executeCommand(deviceId=" + deviceId + ", command=" + command + ")"));
        ExecCmdApp app = new ExecCmdApp(this.gatewayDeviceConnection);
        this.result = new CmdResult();
        if (!app.executeCommand(deviceId, command, this)) {
            log.warn((Object)("Failed to send command '" + command + "' to device with deviceId=" + deviceId + "."));
            return null;
        }
        this.latch = new CountDownLatch(1);
        try {
            this.latch.await(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.result;
    }

    @Override
    public void execCmdEffect(String id, String output, int statusCode) {
        log.debug((Object)("start execCmdEffect(id=" + id + ", output=" + output + ", statusCode=" + statusCode + ")"));
        this.result.setOutput(output);
        this.result.setStatusCode(statusCode);
        this.latch.countDown();
    }

    @Override
    public void execCmdError(String id) {
        log.debug((Object)("start execCmdError(id=" + id + ")"));
        this.result = null;
        this.latch.countDown();
    }
}

