/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.UDPProxy;

import homemonitor.Application;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.UDPProxy.UDPProxyInterface;
import homemonitor.UDPProxy.UDPProxyResponseInterface;
import homemonitor.Utility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class UDPProxy
extends Application
implements UDPProxyInterface {
    private static Logger log = Logger.getLogger(UDPProxy.class);
    private GatewayDeviceConnectionInterface gatewayDeviceConnection;
    private HashMap<Long, UDPProxyResponseInterface> responseHandlerMap = new HashMap();
    private HashMap<Long, Boolean> keepaliveMap = new HashMap();
    private Timer keepaliveCheckTimer = new Timer();
    static final int UDPKeepAlive = 67;
    static final int UDPKeepAliveResp = 68;
    static final int UDPBind = 69;

    public UDPProxy(GatewayDeviceConnectionInterface gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
        this.keepaliveCheckTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                UDPProxy.this.removeDeadDevices();
            }
        }, 30000L, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionDisconnected(String deviceId, Long sessionId) {
        HashMap<Long, Object> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            UDPProxyResponseInterface resp = this.responseHandlerMap.remove(sessionId);
            if (resp != null) {
                resp.deviceDisconnected(sessionId);
            }
        }
        hashMap = this.keepaliveMap;
        synchronized (hashMap) {
            this.keepaliveMap.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        UDPProxyResponseInterface response;
        HashMap<Long, UDPProxyResponseInterface> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            response = this.responseHandlerMap.get(sessionId);
        }
        if (tag == 0) {
            if (data[0] != 0) {
                log.warn((Object)"UDPProxy: got Status Error from GD.");
            }
            return;
        }
        if (response == null) {
            log.warn((Object)("UDPProxy: received response when session " + sessionId + " closed already"));
            return;
        }
        if (tag == 67) {
            this.gatewayDeviceConnection.send(68, sessionId, null);
            this.keepaliveMap.put(sessionId, true);
            return;
        }
        if (data.length < 6) {
            log.warn((Object)("UDPProxy: received too short (" + data.length + "<6) response for session " + sessionId));
            return;
        }
        int srcAddress = Utility.byteArrayToInt(data, 0, 4);
        int srcPort = Utility.byteArrayToInt(data, 4, 2);
        int offset = 6;
        byte[] payload = new byte[data.length - 6];
        for (int i = 0; i < data.length - 6; ++i) {
            payload[i] = data[offset++];
        }
        response.received(srcAddress, srcPort, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createSession(String deviceId, UDPProxyResponseInterface responseHandler) {
        long session = this.gatewayDeviceConnection.createSession(deviceId, this);
        if (session != 0L) {
            HashMap<Long, Object> hashMap = this.responseHandlerMap;
            synchronized (hashMap) {
                this.responseHandlerMap.put(session, responseHandler);
            }
            hashMap = this.keepaliveMap;
            synchronized (hashMap) {
                this.keepaliveMap.put(session, true);
            }
        }
        this.sessionAdd(deviceId, session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(long sessionId, int port) {
        HashMap<Long, UDPProxyResponseInterface> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            if (!this.responseHandlerMap.containsKey(sessionId) || sessionId == 0L) {
                log.warn((Object)("Unable to send, no device connected for sessionId: " + sessionId));
                return;
            }
        }
        byte[] datagram = new byte[2];
        int offset = 0;
        byte[] portArray = Utility.intToByteArray(port);
        for (int i = 2; i < 4; ++i) {
            datagram[offset++] = portArray[i];
        }
        this.gatewayDeviceConnection.send(69, sessionId, datagram);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode send(long sessionId, long address, int dstPort, byte[] payload) {
        int i;
        HashMap<Long, UDPProxyResponseInterface> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            if (!this.responseHandlerMap.containsKey(sessionId) || sessionId == 0L) {
                log.warn((Object)("Unable to send, no device connected for sessionId: " + sessionId));
                return GDErrorCode.WrongSessionID;
            }
        }
        byte[] datagram = new byte[payload.length + 8];
        int offset = 0;
        byte[] addressArray = Utility.intToByteArray((int)address);
        for (int i2 = 0; i2 < 4; ++i2) {
            datagram[offset++] = addressArray[i2];
        }
        byte[] dstPortArray = Utility.intToByteArray(dstPort);
        for (int i3 = 2; i3 < 4; ++i3) {
            datagram[offset++] = dstPortArray[i3];
        }
        byte[] srcPortArray = Utility.intToByteArray(0);
        for (i = 2; i < 4; ++i) {
            datagram[offset++] = srcPortArray[i];
        }
        for (i = 0; i < payload.length; ++i) {
            datagram[offset++] = payload[i];
        }
        GDErrorCode error = this.gatewayDeviceConnection.send(64, sessionId, datagram);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode close(long sessionId) {
        HashMap<Long, Object> hashMap = this.responseHandlerMap;
        synchronized (hashMap) {
            if (!this.responseHandlerMap.containsKey(sessionId) || sessionId == 0L) {
                log.warn((Object)("Unable to close, no device connected for sessionId: " + sessionId));
                return GDErrorCode.WrongSessionID;
            }
            this.responseHandlerMap.remove(sessionId);
        }
        hashMap = this.keepaliveMap;
        synchronized (hashMap) {
            this.keepaliveMap.remove(sessionId);
        }
        GDErrorCode error = this.gatewayDeviceConnection.send(66, sessionId, new byte[0]);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeadDevices() {
        Iterator<Map.Entry<Long, Boolean>> it = null;
        HashMap<Long, Boolean> hashMap = this.keepaliveMap;
        synchronized (hashMap) {
            it = this.keepaliveMap.entrySet().iterator();
        }
        while (it.hasNext()) {
            Map.Entry<Long, Boolean> entry = it.next();
            if (entry.getValue().booleanValue()) {
                HashMap<Long, Boolean> hashMap2 = this.keepaliveMap;
                synchronized (hashMap2) {
                    this.keepaliveMap.put(entry.getKey(), false);
                    continue;
                }
            }
            this.close(entry.getKey());
        }
    }
}

