/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.TCPProxy;

import homemonitor.TCPProxy.Session;
import homemonitor.TCPProxy.TCPProxyInterface;
import homemonitor.TCPProxy.TCPProxyNotification;
import homemonitor.TCPProxy.TCPProxyResponseInterface;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TCPProxyApp
implements TCPProxyResponseInterface {
    private static Logger log = Logger.getLogger(TCPProxyApp.class);
    final int BufferSize = 2048;
    final String ListeningAddress = "0.0.0.0";
    long ticks;
    long totalData = 0L;
    private String deviceAddress;
    private String dstAddress;
    private int dstPort;
    private int localPort;
    private TCPProxyInterface proxy;
    private Map<SocketChannel, Session> sessions = Collections.synchronizedMap(new HashMap());
    private Map<Long, SocketChannel> sockets = Collections.synchronizedMap(new HashMap());
    private ServerSocketChannel serverSocket;
    private Selector selector;
    private TCPProxyNotification notification;
    boolean running = true;
    Thread networkThread;

    public void beanDestroyed() {
        this.running = false;
        this.selector.wakeup();
    }

    public TCPProxyApp() {
    }

    public TCPProxyApp(int localPort, String deviceAddress, String dstAddress, int dstPort, TCPProxyInterface proxy, TCPProxyNotification notification) {
        this.proxy = proxy;
        this.deviceAddress = deviceAddress;
        this.dstAddress = dstAddress;
        this.dstPort = dstPort;
        this.localPort = localPort;
        this.notification = notification;
    }

    public void setDeviceAddress(String deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    public void setDstAddress(String dstAddress) {
        this.dstAddress = dstAddress;
    }

    public void setDstPort(int dstPort) {
        this.dstPort = dstPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public void setProxy(TCPProxyInterface proxy) {
        this.proxy = proxy;
    }

    public void setNotification(TCPProxyNotification notification) {
        this.notification = notification;
    }

    public void start() {
        try {
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.configureBlocking(false);
            this.serverSocket.socket().bind(new InetSocketAddress("0.0.0.0", this.localPort));
            this.selector = Selector.open();
            this.serverSocket.register(this.selector, 16);
            this.networkThread = new NetworkThread();
            this.networkThread.start();
            if (this.notification != null) {
                this.notification.serverStarted();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop() {
        this.running = false;
        this.selector.wakeup();
        this.networkThread = null;
        for (SocketChannel socket : this.sockets.values()) {
            this.closeClientConnection(socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void listen() throws Exception {
        this.selector.select();
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> i = keys.iterator();
        while (i.hasNext()) {
            SocketChannel socket;
            SelectionKey key = i.next();
            i.remove();
            if (key.isAcceptable()) {
                Session session = new Session();
                session.id = this.proxy.connect(this.deviceAddress, this.dstAddress, this.dstPort, this);
                SocketChannel socket2 = this.serverSocket.accept();
                socket2.configureBlocking(false);
                socket2.register(this.selector, 1);
                this.sessions.put(socket2, session);
                this.sockets.put(session.id, socket2);
                if (this.notification == null) continue;
                this.notification.clientConnected(((InetSocketAddress)socket2.socket().getRemoteSocketAddress()).getAddress().toString());
                continue;
            }
            if (key.isReadable()) {
                int numRead;
                socket = (SocketChannel)key.channel();
                Session session = this.sessions.get(socket);
                if (!session.accepted) continue;
                ByteBuffer buffer = ByteBuffer.allocate(2048);
                try {
                    numRead = socket.read(buffer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.handleClientClose(socket);
                    key.cancel();
                    socket.close();
                    continue;
                }
                if (numRead == -1) {
                    this.handleClientClose(socket);
                    key.channel().close();
                    key.cancel();
                    continue;
                }
                byte[] array = new byte[numRead];
                System.arraycopy(buffer.array(), 0, array, 0, numRead);
                log.trace((Object)("received from client: " + numRead));
                this.proxy.send(session.id, array);
                continue;
            }
            if (!key.isWritable()) continue;
            socket = (SocketChannel)key.channel();
            Map<SocketChannel, Session> map = this.sessions;
            synchronized (map) {
                Session session = this.sessions.get(socket);
                if (!session.accepted) {
                    continue;
                }
                List<ByteBuffer> queue = session.buffers;
                if (queue == null) {
                    queue = new ArrayList<ByteBuffer>();
                }
                if (!queue.isEmpty()) {
                    if (socket.isOpen()) {
                        socket.write(queue.get(0));
                        log.trace((Object)("sent to client: " + queue.get(0).position()));
                        queue.remove(0);
                    } else {
                        this.closeClientConnection(socket);
                    }
                }
                if (queue.isEmpty()) {
                    if (key.isValid()) {
                        key.interestOps(1);
                    }
                    if (session.closeRequested) {
                        this.closeClientConnection(socket);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeClientConnection(SocketChannel socket) {
        Map<SocketChannel, Session> map = this.sessions;
        synchronized (map) {
            List<ByteBuffer> queue;
            Session session = this.sessions.get(socket);
            if (session != null && (queue = session.buffers) != null && !queue.isEmpty()) {
                session.closeRequested = true;
                SelectionKey key = socket.keyFor(this.selector);
                key.interestOps(4);
                return;
            }
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        socket.keyFor(this.selector).cancel();
        this.handleClientClose(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(long sessionId, byte[] data) {
        if (this.totalData == 0L) {
            this.ticks = System.currentTimeMillis();
        }
        this.totalData += (long)(data.length + 8);
        Map<SocketChannel, Session> map = this.sessions;
        synchronized (map) {
            SocketChannel socket = this.sockets.get(sessionId);
            Session session = this.sessions.get(socket);
            if (session == null) {
                this.deviceDisconnected(sessionId);
            }
            if (session.buffers == null) {
                session.buffers = new ArrayList<ByteBuffer>();
            }
            session.buffers.add(ByteBuffer.wrap(data));
            SelectionKey key = socket.keyFor(this.selector);
            if (key != null) {
                key.interestOps(4);
            } else {
                this.deviceDisconnected(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClientClose(SocketChannel socket) {
        this.ticks = System.currentTimeMillis() - this.ticks;
        log.debug((Object)("received bytes: " + this.totalData + ", time: " + this.ticks / 1000L));
        if (this.ticks / 1000L > 0L) {
            log.debug((Object)("at " + this.totalData / 1024L / (this.ticks / 1000L) + " kB/s"));
        }
        this.totalData = 0L;
        Map<SocketChannel, Session> map = this.sessions;
        synchronized (map) {
            Session session = this.sessions.remove(socket);
            if (session != null) {
                SocketAddress address;
                this.sockets.remove(session.id);
                this.proxy.disconnect(session.id);
                if (this.notification != null && socket != null && (address = socket.socket().getRemoteSocketAddress()) != null) {
                    this.notification.clientDisconnected(address.toString());
                }
            }
        }
    }

    @Override
    public void accepted(long sessionId) {
        SocketChannel socket = this.sockets.get(sessionId);
        Session session = this.sessions.get(socket);
        session.accepted = true;
        if (this.notification != null) {
            this.notification.connectionAccepted(this.dstAddress);
        }
    }

    @Override
    public void error(long sessionId) {
        this.closeClientConnection(this.sockets.get(sessionId));
        if (this.notification != null) {
            this.notification.error();
        }
    }

    @Override
    public void closed(long sessionId) {
        this.closeClientConnection(this.sockets.get(sessionId));
        if (this.notification != null) {
            this.notification.closed();
        }
    }

    @Override
    public void deviceDisconnected(long sessionId) {
        if (this.notification != null) {
            this.notification.deviceDisconnected();
        }
    }

    public int getLocalPort() {
        return this.serverSocket.socket().getLocalPort();
    }

    class NetworkThread
    extends Thread {
        NetworkThread() {
        }

        @Override
        public void run() {
            super.setName("GDServerTCPProxyThread");
            try {
                TCPProxyApp.this.running = true;
                while (TCPProxyApp.this.running) {
                    try {
                        TCPProxyApp.this.listen();
                    }
                    catch (CancelledKeyException exception) {
                        exception.printStackTrace();
                    }
                }
                try {
                    TCPProxyApp.this.serverSocket.socket().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

