/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.ICETransport;

import homemonitor.Application;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.ICETransport.ICETransportInterface;
import homemonitor.ICETransport.ICETransportReceiverInterface;
import homemonitor.Utility;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ICETransport
extends Application
implements ICETransportInterface {
    private static final int ICESTART_TAG = 32;
    private static final int ICECAND_TAG = 33;
    private static final int ICEOK_TAG = 36;
    private static final int ICEFAILED_TAG = 37;
    private static Logger log = Logger.getLogger(ICETransport.class);
    private GatewayDeviceConnectionInterface connection;
    private HashMap<Long, ICETransportReceiverInterface> sessionHandlers = new HashMap();

    public ICETransport(GatewayDeviceConnectionInterface con) {
        this.connection = con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionDisconnected(String deviceId, Long sessionId) {
        HashMap<Long, ICETransportReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            ICETransportReceiverInterface receiver = this.sessionHandlers.remove(sessionId);
            if (receiver != null) {
                receiver.deviceDisconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        ICETransportReceiverInterface response;
        HashMap<Long, ICETransportReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            response = this.sessionHandlers.get(sessionId);
        }
        if (tag == 0) {
            if (data[0] != 0) {
                log.warn((Object)("ICETransport: got Status Error (" + data[0] + ") from GD."));
                response.received(0, 0, null);
                this.sessionDelete(sessionId);
            }
            return;
        }
        if (response == null) {
            log.warn((Object)("ICETransport: received response when session " + sessionId + " closed already"));
            return;
        }
        switch (tag) {
            case 33: {
                log.trace((Object)"Received ICECAND tag");
                int portStart = Utility.byteArrayToInt(data, 0, 2);
                log.trace((Object)("Received start port: " + portStart));
                int portEnd = Utility.byteArrayToInt(data, 2, 2);
                log.trace((Object)("Received end port: " + portEnd));
                String localCand = Utility.byteArrayASCIIToString(data, 4);
                log.trace((Object)("Received local candidates: " + localCand));
                response.received(portStart, portEnd, localCand);
                break;
            }
            case 36: {
                log.trace((Object)"Received ICEOK tag");
                this.sessionDelete(sessionId);
                break;
            }
            case 37: {
                log.trace((Object)"Received ICEFAILED tag");
                response.received(0, 0, null);
                this.sessionDelete(sessionId);
                break;
            }
            default: {
                log.warn((Object)("Received unknown identifier: " + tag + "."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createSession(String deviceID, ICETransportReceiverInterface receiver) {
        long sessionID = this.connection.createSession(deviceID, this);
        if (sessionID != 0L) {
            HashMap<Long, ICETransportReceiverInterface> hashMap = this.sessionHandlers;
            synchronized (hashMap) {
                this.sessionHandlers.put(sessionID, receiver);
            }
            this.sessionAdd(deviceID, sessionID);
        }
        return sessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode send(long sessionID, String stunAddr, int stunPort, String turnAddr, int turnPort, String turnUser, String turnPass, String candidates) {
        log.trace((Object)("start send(sessionID=" + sessionID + ", stunAddr=" + stunAddr + ", stunPort=" + stunPort + ", trunAddr=" + turnAddr + ", turnPort=" + turnPort + ", turnUser=" + turnUser + ", turnPass=" + turnPass + ", candidates=" + candidates + ")"));
        HashMap<Long, ICETransportReceiverInterface> hashMap = this.sessionHandlers;
        synchronized (hashMap) {
            if (!this.sessionHandlers.containsKey(sessionID) || sessionID == 0L) {
                log.warn((Object)"No device connected");
                return GDErrorCode.WrongSessionID;
            }
        }
        byte[] payload = this.preparePayload(stunAddr, stunPort, turnAddr, turnPort, turnUser, turnPass, candidates);
        log.trace((Object)"sending payload");
        GDErrorCode status = this.connection.send(32, sessionID, payload);
        log.trace((Object)("send status: " + (Object)((Object)status)));
        return status;
    }

    private byte[] preparePayload(String stunAddr, int stunPort, String turnAddr, int turnPort, String turnUser, String turnPass, String candidates) {
        int i;
        byte[] turnPassArray;
        int i2;
        byte[] data = new byte[candidates.length() + 44];
        int offset = 0;
        byte[] stunAddrArray = Utility.ipAddressToByteArray(stunAddr);
        for (int i3 = 0; i3 < 4; ++i3) {
            data[offset++] = stunAddrArray[i3];
        }
        byte[] stunPortArray = Utility.intToByteArray(stunPort);
        for (int i4 = 2; i4 < 4; ++i4) {
            data[offset++] = stunPortArray[i4];
        }
        byte[] turnAddrArray = Utility.ipAddressToByteArray(turnAddr);
        for (int i5 = 0; i5 < 4; ++i5) {
            data[offset++] = turnAddrArray[i5];
        }
        byte[] turnPortArray = Utility.intToByteArray(turnPort);
        for (int i6 = 2; i6 < 4; ++i6) {
            data[offset++] = turnPortArray[i6];
        }
        byte[] turnUserArray = Utility.stringToByteArray(turnUser);
        if (turnUserArray.length > 16) {
            log.error((Object)"Turn user name is longer than 16 bytes!");
            turnUserArray = this.subArray(turnUserArray, 16);
        }
        for (int i7 = 0; i7 < turnUserArray.length; ++i7) {
            data[offset++] = turnUserArray[i7];
        }
        if (turnUserArray.length < 16) {
            int diff = 16 - turnUserArray.length;
            for (i2 = 0; i2 < diff; ++i2) {
                data[offset++] = 0;
            }
        }
        if ((turnPassArray = Utility.stringToByteArray(turnPass)).length > 16) {
            log.error((Object)"Turn password is longer than 16 bytes!");
            turnPassArray = this.subArray(turnPassArray, 16);
        }
        for (i2 = 0; i2 < turnPassArray.length; ++i2) {
            data[offset++] = turnPassArray[i2];
        }
        if (turnPassArray.length < 16) {
            int diff = 16 - turnPassArray.length;
            for (i = 0; i < diff; ++i) {
                data[offset++] = 0;
            }
        }
        byte[] candArray = candidates.getBytes();
        for (i = 0; i < candArray.length; ++i) {
            data[offset++] = candArray[i];
        }
        return data;
    }

    private byte[] subArray(byte[] src, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = src[i];
        }
        return result;
    }
}

