/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.HTTPClient;

import com.vestiacom.gdserver.util.Utils;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public class ApacheHttpClient
extends DefaultHttpClient {
    private static Logger log = Logger.getLogger(ApacheHttpClient.class);

    public ApacheHttpClient(ClientConnectionManager conman, String proxyAddress, Integer proxyPort) {
        super(conman);
        HttpConnectionParams.setSoTimeout((HttpParams)this.getParams(), (int)2000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.getParams(), (int)2000);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)this.getParams(), (boolean)true);
        if (!Utils.isBlank(proxyAddress)) {
            log.debug((Object)("Creating HttpClient with proxy: " + proxyAddress + ", " + proxyPort));
            HttpHost proxy = new HttpHost(proxyAddress, proxyPort.intValue());
            this.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        } else {
            log.debug((Object)"Creating HttpClient without proxy");
        }
    }

    public static class SSLSocketFactory
    extends org.apache.http.conn.ssl.SSLSocketFactory {
        private String cipherSuite = null;

        private static SSLContext createSSLContext() {
            try {
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(null, null);
                KeyManager[] keymanagers = kmfactory.getKeyManagers();
                TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore truststore = null;
                tmfactory.init(truststore);
                TrustManager[] trustmanagers = tmfactory.getTrustManagers();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keymanagers, trustmanagers, null);
                return sslContext;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new IllegalStateException();
            }
        }

        SSLSocketFactory(String cipherSuite) {
            super(SSLSocketFactory.createSSLContext(), ALLOW_ALL_HOSTNAME_VERIFIER);
            this.cipherSuite = cipherSuite;
        }

        private Socket sslize(Socket s) {
            SSLSocket sock = (SSLSocket)s;
            sock.setEnabledCipherSuites(new String[]{this.cipherSuite});
            return sock;
        }

        public Socket createSocket(HttpParams params) throws IOException {
            Socket s = super.createSocket(params);
            return this.sslize(s);
        }

        @Deprecated
        public Socket createSocket() throws IOException {
            Socket s = super.createSocket();
            return this.sslize(s);
        }

        @Deprecated
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            Socket s = super.createSocket(socket, host, port, autoClose);
            return this.sslize(s);
        }

        public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            Socket s = super.createLayeredSocket(socket, host, port, autoClose);
            return this.sslize(s);
        }
    }
}

