/*
 * Decompiled with CFR 0.152.
 */
package homemonitor;

import com.vestiacom.gdserver.db.dao.DaoFactory;
import com.vestiacom.gdserver.db.entity.SessionEntity;
import com.vestiacom.gdserver.rest.model.BlockedDevice;
import com.vestiacom.gdserver.service.HttpProxyVerificationService;
import com.vestiacom.gdserver.service.RestProxyService;
import com.vestiacom.gdserver.service.ServiceFactory;
import com.vestiacom.gdserver.service.impl.Blockade;
import com.vestiacom.gdserver.service.impl.Blockades;
import djb.Curve25519;
import homemonitor.BlockPeriodCache;
import homemonitor.GDErrorCode;
import homemonitor.GatewayDevice;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.GatewayDeviceConnectionListener;
import homemonitor.Message;
import homemonitor.SenderInterface;
import homemonitor.ServerBackendInterface;
import homemonitor.ServerBackendReceiverInterface;
import homemonitor.Session;
import homemonitor.Utility;
import homemonitor.encryption.EncryptionHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class GatewayDeviceConnection
implements GatewayDeviceConnectionInterface,
ServerBackendReceiverInterface {
    private static Logger log = Logger.getLogger(GatewayDeviceConnection.class);
    public static final int CookieOffset = 0;
    public static final int TagOffset = 1;
    public static final int LengthOffset = 2;
    public static final int SessionIdOffset = 4;
    public static final int ValueOffset = 8;
    public static final int TCPOverUDPTunResp = 17;
    public static final int StatusTag = 0;
    public static final int HelloTag = 1;
    public static final int VerifyTag = 2;
    public static final int VerifyResponseTag = 3;
    public static final int KeepAliveTag = 4;
    public static final int KeepAliveResponseTag = 5;
    public static final int ResetTag = 6;
    public static final int ForceUpgradeTag = 7;
    public static final int HelloTlsTag = 8;
    public static final int VerifyTlsTag = 9;
    public static final int EncryptedTag = 10;
    public static final int LogsTag = 20;
    public static final int RestProxyRequest = 22;
    public static final int RestProxyResponse = 23;
    public static final int SetupForwardingTag = 48;
    public static final int SetupForwardingStatusTag = 49;
    public static final int VerifySessionIdTag = 50;
    public static final int VerifySessionIdRespTag = 51;
    public static final int RemoveForwardingTag = 52;
    public static final int ExecCmdTag = 80;
    public static final int ExecOutputTag = 81;
    public static final int ExecStatusTag = 82;
    public static final int KeySignRequest = 96;
    public static final int KeySignResponse = 97;
    public static final int KeyDecryptRequest = 98;
    public static final int KeyDecryptResponse = 99;
    public static final int KeyDhmCalcSecretRequest = 100;
    public static final int KeyDhmCalcSecretResponse = 101;
    public static final int KeySignWithHashRequest = 102;
    public static final int KeySignWithHashResponse = 103;
    public static final int EncryptionRequestTag = 250;
    public static final int EncryptionResponseTag = 251;
    private ServerBackendInterface serverBackend;
    public static final byte Cookie = -105;
    long lastId = 1L;
    HashMap<String, GatewayDevice> devices = new HashMap();
    HashMap<String, GatewayDevice> unverifiedDevices = new HashMap();
    HashMap<String, ByteBuffer> incomingMessagesBuffer = new HashMap();
    HashMap<Long, Session> sessions = new HashMap();
    List<GatewayDeviceConnectionListener> listeners = new ArrayList<GatewayDeviceConnectionListener>();
    private String firmwareVersion;
    private String restUrl;
    private ServiceFactory serviceFactory;
    private DaoFactory daoFactory;
    private BlockPeriodCache blockPeriodCache;
    private Blockades blockades;
    private boolean automaticUnblockingEnabled;
    private LinkedBlockingQueue<String> signingQueue = new LinkedBlockingQueue();
    static final int blockSize = 16;
    byte[] myPrivateKey = new byte[32];
    byte[] myPublicKey = new byte[32];
    byte[] myPrivateKeyForSigning = new byte[32];
    private EncryptionHelper encryptionHelper;

    @Autowired
    @Required
    public void setServiceFactory(ServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    @Autowired
    @Required
    public void setDaoFactory(DaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Autowired
    @Required
    public void setBlockPeriod(BlockPeriodCache blockPeriodCache) {
        this.blockPeriodCache = blockPeriodCache;
    }

    @Autowired
    @Required
    public void setBlockades(Blockades blockades) {
        this.blockades = blockades;
    }

    public void setRestUrl(String restUrl) throws URISyntaxException {
        new URI(restUrl);
        this.restUrl = restUrl;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public void setListeners(List<GatewayDeviceConnectionListener> listeners) {
        this.listeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVerifiedDevice(String mac, String publicIp, String localIp) {
        GatewayDevice device = new GatewayDevice(mac, publicIp, localIp);
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            this.devices.put(mac, device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVerifiedDevice(String mac) {
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            this.devices.remove(mac);
        }
    }

    private GatewayDeviceConnection() {
        this.initEncryption();
        this.initSigningThread();
    }

    public GatewayDeviceConnection(EncryptionHelper encryptionHelper) {
        this.encryptionHelper = encryptionHelper;
    }

    private void initSigningThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            String deviceId = null;
                            try {
                                deviceId = (String)GatewayDeviceConnection.this.signingQueue.take();
                            }
                            catch (InterruptedException e) {
                                continue;
                            }
                            byte[] message = GatewayDeviceConnection.this.createEncryptionResponseMessage();
                            ServerBackendInterface serverBackendInterface = GatewayDeviceConnection.this.serverBackend;
                            synchronized (serverBackendInterface) {
                                GatewayDeviceConnection.this.serverBackend.send(deviceId, message);
                            }
                        }
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Failed to process encryption message: " + ex.getMessage()));
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public GatewayDeviceConnection(String rsaKeyPath, String rsaKeyCertPath, String caCertPath, String restUrl, boolean automaticUnblockingEnabled) throws URISyntaxException {
        this();
        this.setRestUrl(restUrl);
        this.encryptionHelper = new EncryptionHelper(this, rsaKeyPath, rsaKeyCertPath, caCertPath);
        this.automaticUnblockingEnabled = automaticUnblockingEnabled;
    }

    static byte[] kdf(byte[] sharedKey) {
        byte[] hashedKey = new byte[16];
        System.arraycopy(sharedKey, 0, hashedKey, 0, 16);
        return hashedKey;
    }

    void initEncryption() {
        Random rd = new Random();
        rd.nextBytes(this.myPrivateKey);
        Curve25519.keygen(this.myPublicKey, this.myPrivateKeyForSigning, this.myPrivateKey);
    }

    void setOtherPublicKey(GatewayDevice device, byte[] pubkey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        System.arraycopy(pubkey, 0, device.PublicKey, 0, device.PublicKey.length);
        Curve25519.curve(device.sharedSecretKey, this.myPrivateKey, device.PublicKey);
        byte[] hashedSharedSecretKey = GatewayDeviceConnection.kdf(device.sharedSecretKey);
        device.secretKey = new SecretKeySpec(hashedSharedSecretKey, "AES");
    }

    byte[] encrypt(GatewayDevice device, byte[] fullMessage) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Cipher encCipher;
        byte[] iv = new byte[16];
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.nextBytes(iv);
        try {
            encCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException();
        }
        catch (NoSuchPaddingException e) {
            throw new BadPaddingException();
        }
        encCipher.init(1, (Key)device.secretKey, new IvParameterSpec(iv));
        byte[] encrypted = encCipher.doFinal(fullMessage);
        byte[] msg = new byte[encrypted.length + iv.length];
        System.arraycopy(iv, 0, msg, 0, iv.length);
        System.arraycopy(encrypted, 0, msg, iv.length, encrypted.length);
        return msg;
    }

    byte[] encrypt(String deviceId, byte[] message) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        byte[] encrypted = null;
        GatewayDevice device = this.findAnyById(deviceId);
        if (device != null) {
            encrypted = this.encrypt(device, message);
        }
        return encrypted;
    }

    byte[] decrypt(GatewayDevice device, byte[] message) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher decCipher;
        byte[] iv = new byte[16];
        System.arraycopy(message, 0, iv, 0, iv.length);
        try {
            decCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException();
        }
        catch (NoSuchPaddingException e) {
            throw new BadPaddingException();
        }
        decCipher.init(2, (Key)device.secretKey, new IvParameterSpec(iv));
        byte[] decrypted = decCipher.doFinal(message, iv.length, message.length - iv.length);
        return decrypted;
    }

    byte[] decrypt(String deviceId, byte[] message) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] decrypted = null;
        GatewayDevice device = this.findAnyById(deviceId);
        if (device != null) {
            decrypted = this.decrypt(device, message);
        }
        return decrypted;
    }

    byte[] getPublicKey() {
        return this.myPublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createSession(String deviceId, SenderInterface sender) {
        GatewayDevice device = null;
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            device = this.devices.get(deviceId);
        }
        if (device == null) {
            log.info((Object)("cannot create session on not connected device " + deviceId));
            return 0L;
        }
        long result = this.getSessionId();
        Session session = new Session(deviceId, sender);
        Cloneable cloneable = this.sessions;
        synchronized (cloneable) {
            this.sessions.put(result, session);
        }
        cloneable = device.sessions;
        synchronized (cloneable) {
            device.sessions.add(session);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSessionId() {
        HashMap<Long, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            Set<Long> currentSessionIds = this.sessions.keySet();
            while (currentSessionIds.contains(++this.lastId)) {
                if (this.lastId != 0xFFFFFFL) continue;
                this.lastId = 0L;
            }
            return this.lastId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySession(long sessionId) {
        Session session = null;
        HashMap<Long, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            session = this.sessions.remove(sessionId);
        }
        GatewayDevice device = null;
        Cloneable cloneable = this.devices;
        synchronized (cloneable) {
            device = this.devices.get(session.deviceId);
        }
        if (device != null) {
            cloneable = device.sessions;
            synchronized (cloneable) {
                device.sessions.remove(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countDevices() {
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            return this.devices.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayDevice findById(String id) {
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            return this.devices.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GatewayDevice findAnyById(String id) {
        GatewayDevice device = null;
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            device = this.devices.get(id);
        }
        if (device == null) {
            hashMap = this.unverifiedDevices;
            synchronized (hashMap) {
                device = this.unverifiedDevices.get(id);
            }
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode send(int tag, long sessionId, byte[] data) {
        Session session;
        log.trace((Object)("start send(tag=" + tag + ", sessionId=" + sessionId + ", data with size=" + (data == null ? "null" : Integer.valueOf(data.length)) + ")"));
        HashMap<Long, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            session = this.sessions.get(sessionId);
            if (session == null) {
                return GDErrorCode.WrongSessionID;
            }
        }
        byte[] message = GatewayDeviceConnection.createMessage(tag, sessionId, data);
        GatewayDevice device = this.findAnyById(session.deviceId);
        if (device != null && device.encryptedControlConnection && tag != 10) {
            try {
                message = this.encrypt(device, message);
                return this.sendSimple(10, session.deviceId, message);
            }
            catch (Exception e) {
                log.warn((Object)("cannot encrypt message: " + e.getMessage()));
                return GDErrorCode.Error;
            }
        }
        ServerBackendInterface serverBackendInterface = this.serverBackend;
        synchronized (serverBackendInterface) {
            this.serverBackend.send(session.deviceId, message);
        }
        return GDErrorCode.NoError;
    }

    @Override
    public GDErrorCode sendSimple(int tag, String deviceId, byte[] data) {
        return this.sendSimple(tag, deviceId, "0", data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GDErrorCode sendSimple(int tag, String deviceId, String sessionId, byte[] data) {
        byte[] message = GatewayDeviceConnection.createMessage(tag, Long.parseLong(sessionId), data);
        GatewayDevice device = this.findAnyById(deviceId);
        if (device != null && device.encryptedControlConnection && tag != 10) {
            try {
                message = this.encrypt(device, message);
                return this.sendSimple(10, deviceId, message);
            }
            catch (Exception e) {
                log.warn((Object)("cannot encrypt message: " + e.getMessage()));
                return GDErrorCode.Error;
            }
        }
        ServerBackendInterface serverBackendInterface = this.serverBackend;
        synchronized (serverBackendInterface) {
            this.serverBackend.send(deviceId, message);
        }
        return GDErrorCode.NoError;
    }

    private static byte[] createMessage(int tag, long sessionId, byte[] data) {
        int length = data == null ? 0 : data.length;
        byte[] message = new byte[8 + length];
        message[0] = -105;
        message[1] = (byte)tag;
        byte[] lengthAsArray = Utility.intToByteArray(length);
        message[2] = lengthAsArray[2];
        message[3] = lengthAsArray[3];
        byte[] serviceIdArray = Utility.intToByteArray((int)sessionId);
        for (int i = 0; i < 4; ++i) {
            message[4 + i] = serviceIdArray[i];
        }
        if (data != null) {
            System.arraycopy(data, 0, message, 8, length);
        }
        return message;
    }

    @Override
    public void receivedData(String publicIp, String deviceId, ByteBuffer data) {
        log.trace((Object)("start receivedData(publicIp=" + publicIp + ", deviceId=" + deviceId + ", data=" + data + ")"));
        ByteBuffer buffer = this.incomingMessagesBuffer.get(deviceId);
        if (buffer == null) {
            buffer = data;
        } else {
            data.flip();
            ByteBuffer joinedBuffers = ByteBuffer.allocate(buffer.remaining() + data.remaining());
            joinedBuffers.put(buffer);
            joinedBuffers.put(data);
            buffer = joinedBuffers;
        }
        buffer.flip();
        ByteBuffer remainingBuffer = this.extractMessages(buffer, deviceId, publicIp);
        this.incomingMessagesBuffer.put(deviceId, remainingBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer extractMessages(ByteBuffer buffer, String deviceId, String publicIp) {
        Message message;
        log.trace((Object)"Before while loop");
        block53: while ((message = this.extractMessage(buffer, deviceId)) != null) {
            Session session;
            log.trace((Object)("GDC got tag: " + message.tag + ", sessionId: " + message.sessionId + ". len: " + message.data.length));
            switch (message.tag) {
                case 8: {
                    String mac = Utility.byteArrayToHexString(message.data, 0, 6, ":");
                    String localIp = Utility.byteArrayToString(message.data, 6, 4, ".");
                    boolean contains = false;
                    HashMap<String, GatewayDevice> hashMap = this.devices;
                    synchronized (hashMap) {
                        contains = this.devices.containsKey(mac);
                    }
                    if (contains) {
                        this.deviceDisconnected(mac, "GDCLIENT_RECONNECT");
                    }
                    byte supportedServices = (byte)Utility.byteArrayToInt(message.data, 10, 1);
                    byte[] salt = new byte[16];
                    System.arraycopy(message.data, 14, salt, 0, 16);
                    byte versionMajor = (byte)Utility.byteArrayToInt(message.data, 30, 1);
                    byte versionMinor = (byte)Utility.byteArrayToInt(message.data, 31, 1);
                    short buildNo = (short)Utility.byteArrayToInt(message.data, 32, 2);
                    byte deviceType = (byte)Utility.byteArrayToInt(message.data, 34, 1);
                    byte deviceHash = (byte)Utility.byteArrayToInt(message.data, 35, 1);
                    byte[] publicKey = new byte[32];
                    System.arraycopy(message.data, 36, publicKey, 0, 32);
                    GatewayDevice device = new GatewayDevice(mac, publicIp, localIp, versionMajor, versionMinor, buildNo, deviceType, deviceHash, supportedServices, null);
                    HashMap<String, GatewayDevice> hashMap2 = this.unverifiedDevices;
                    synchronized (hashMap2) {
                        this.unverifiedDevices.put(deviceId, device);
                    }
                    try {
                        this.setOtherPublicKey(device, publicKey);
                    }
                    catch (Exception e) {
                        log.warn((Object)("error setting public key of device " + mac + ": " + e.getMessage()));
                        this.removeDevice(deviceId);
                    }
                    ServerBackendInterface e = this.serverBackend;
                    synchronized (e) {
                        this.serverBackend.send(deviceId, this.createVerifyTlsMessage(versionMajor, versionMinor, salt));
                    }
                    log.info((Object)("Got hellotls from IP: " + publicIp + " with MAC: " + mac + " and deviceHash: " + deviceHash));
                    device.encryptedControlConnection = true;
                    continue block53;
                }
                case -6: {
                    byte[] publicKey = new byte[32];
                    System.arraycopy(message.data, 0, publicKey, 0, publicKey.length);
                    GatewayDevice stubDevice = GatewayDevice.createStub();
                    try {
                        this.setOtherPublicKey(stubDevice, publicKey);
                        this.scheduleEnryptionResponseMessage(deviceId);
                        stubDevice.encryptedControlConnection = true;
                        HashMap<String, GatewayDevice> supportedServices = this.unverifiedDevices;
                        synchronized (supportedServices) {
                            this.unverifiedDevices.put(deviceId, stubDevice);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("error processing EncryptionRequest from device " + deviceId + "/" + publicIp + ": " + e.getMessage()));
                        this.removeDevice(deviceId);
                    }
                    log.info((Object)("Got EncryptionRequest from IP: " + publicIp));
                    continue block53;
                }
                case 1: {
                    String mac;
                    try {
                        mac = Utility.byteArrayToHexString(message.data, 0, 6, ":");
                        String localIp = Utility.byteArrayToString(message.data, 6, 4, ".");
                        boolean usesMacAsId = true;
                        String serialNumber = null;
                        if (mac.equals("00:00:00:00:00:00")) {
                            if (message.data.length < 38) {
                                log.warn((Object)String.format("Device at IP %s didn't send HA-ID", publicIp));
                                this.removeDevice(deviceId);
                                continue block53;
                            }
                            int deviceIdLength = Utility.byteArrayToInt(message.data, 36, 1);
                            if (deviceIdLength > 0) {
                                mac = Utility.byteArrayASCIIToString(message.data, 37, deviceIdLength);
                            }
                            serialNumber = this.getSerialNumber(message, 37 + deviceIdLength);
                            usesMacAsId = false;
                        } else if (message.data.length > 36) {
                            serialNumber = this.getSerialNumber(message, 36);
                        }
                        boolean contains = false;
                        HashMap<String, GatewayDevice> versionMinor = this.devices;
                        synchronized (versionMinor) {
                            contains = this.devices.containsKey(mac);
                        }
                        if (contains) {
                            this.deviceDisconnected(mac, "GDCLIENT_RECONNECT");
                        }
                        byte supportedServices = (byte)Utility.byteArrayToInt(message.data, 10, 1);
                        byte[] salt = new byte[16];
                        System.arraycopy(message.data, 14, salt, 0, 16);
                        byte versionMajor = (byte)Utility.byteArrayToInt(message.data, 30, 1);
                        byte versionMinor2 = (byte)Utility.byteArrayToInt(message.data, 31, 1);
                        short buildNo = (short)Utility.byteArrayToInt(message.data, 32, 2);
                        byte deviceType = (byte)Utility.byteArrayToInt(message.data, 34, 1);
                        byte deviceHash = (byte)Utility.byteArrayToInt(message.data, 35, 1);
                        GatewayDevice device = new GatewayDevice(mac, publicIp, localIp, versionMajor, versionMinor2, buildNo, deviceType, deviceHash, supportedServices, serialNumber);
                        device.setUsesMacAsId(usesMacAsId);
                        Object object = this.unverifiedDevices;
                        synchronized (object) {
                            GatewayDevice stubDevice = this.unverifiedDevices.remove(deviceId);
                            if (stubDevice != null) {
                                this.setOtherPublicKey(device, stubDevice.PublicKey);
                                device.encryptedControlConnection = stubDevice.encryptedControlConnection;
                            }
                            if (this.isReportedIpSupported(device)) {
                                String reportedIpAddress;
                                device.reportedIpAddress = reportedIpAddress = Utility.byteArrayToString(message.data, 14, 4, ".");
                                log.debug((Object)("Received reported IP address: " + reportedIpAddress + " for device: " + device.mac));
                            }
                            this.unverifiedDevices.put(deviceId, device);
                        }
                        object = this.serverBackend;
                        synchronized (object) {
                            if (device.encryptedControlConnection) {
                                this.serverBackend.send(deviceId, this.createEncryptedVerifyMessage(device));
                                log.info((Object)("Got Encrypted Hello from IP: " + publicIp + " with MAC: " + mac + " and deviceHash: " + deviceHash));
                            } else {
                                this.serverBackend.send(deviceId, this.createVerifyMessage(versionMajor, versionMinor2, salt));
                                log.info((Object)("Got hello from IP: " + publicIp + " with MAC: " + mac + " and deviceHash: " + deviceHash));
                            }
                            continue block53;
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)String.format("Error processing Hello packet from device %s/%s: %s", deviceId, publicIp, e.getMessage()));
                        this.removeDevice(deviceId);
                        continue block53;
                    }
                }
                case 10: {
                    try {
                        byte[] decrypted = this.decrypt(deviceId, message.data);
                        ByteBuffer decBuf = ByteBuffer.wrap(decrypted);
                        this.extractMessages(decBuf, deviceId, publicIp);
                    }
                    catch (Exception e) {
                        log.warn((Object)String.format("Cannot decrypt message from device %s/%s: %s (probably a load balancer check)", deviceId, publicIp, e.getMessage()));
                        this.removeDevice(deviceId);
                    }
                    continue block53;
                }
                case 3: {
                    GatewayDevice device;
                    Object decBuf = this.unverifiedDevices;
                    synchronized (decBuf) {
                        device = this.unverifiedDevices.remove(deviceId);
                    }
                    this.incomingMessagesBuffer.remove(deviceId);
                    this.incomingMessagesBuffer.remove(device.mac);
                    decBuf = this.devices;
                    synchronized (decBuf) {
                        this.devices.put(device.mac, device);
                    }
                    if (this.isReportedIpSupported(device) && !"0.0.0.0".equals(device.reportedIpAddress)) {
                        log.info((Object)("Changing public IP address to reported IP address: " + device.publicIpAddress + " -> " + device.reportedIpAddress + " for device: " + device.mac));
                        device.publicIpAddress = device.reportedIpAddress;
                    }
                    decBuf = this.serverBackend;
                    synchronized (decBuf) {
                        this.serverBackend.deviceVerified(deviceId, device.mac);
                    }
                    log.info((Object)("Device verified: " + device.mac + " IP: " + device.publicIpAddress));
                    if (device.usesMacAsId()) {
                        log.debug((Object)("Device " + device.mac + " uses its ID as serial number."));
                        device.setSerialNumber(device.mac);
                    }
                    if (!this.isDeviceBlocked(device.mac)) {
                        this.notifyListenersConnected(device);
                        this.checkVersionNumber(device);
                        this.handleAutomaticUnblocking(device);
                        continue block53;
                    }
                    log.info((Object)String.format("Verified device %s is blocked, silently ignoring.", device.mac));
                    continue block53;
                }
                case 4: {
                    this.processKeepAlive(deviceId);
                    continue block53;
                }
                case 20: {
                    String logs = Utility.byteArrayASCIIToString(message.data);
                    this.notifyListenersReceivedLogs(deviceId, logs);
                    continue block53;
                }
                case 50: {
                    if (this.isDeviceBlocked(deviceId)) {
                        log.debug((Object)("Processing of tag " + message.tag + " aborted due to device " + deviceId + " being blocked."));
                        continue block53;
                    }
                    ByteBuffer messageBuffer = ByteBuffer.wrap(message.data);
                    short sessionIdLen = messageBuffer.getShort();
                    byte[] sessionIdArray = new byte[sessionIdLen];
                    messageBuffer.get(sessionIdArray, 0, sessionIdLen);
                    boolean ldIdIsGcId = messageBuffer.get() == 1;
                    byte ldIdLen = messageBuffer.get();
                    byte[] ldIdArray = new byte[ldIdLen];
                    messageBuffer.get(ldIdArray, 0, ldIdLen);
                    String gcId = "0";
                    String ldId = "0";
                    if (ldIdIsGcId) {
                        gcId = new String(ldIdArray);
                    } else {
                        ldId = new String(ldIdArray);
                    }
                    HttpProxyVerificationService service = this.serviceFactory.getHttpVerificationService();
                    service.verify(deviceId, message.sessionId, gcId, ldId, new String(sessionIdArray), this);
                    continue block53;
                }
                case 22: {
                    if (this.isDeviceBlocked(deviceId)) {
                        log.debug((Object)("Processing of tag " + message.tag + " aborted due to device " + deviceId + " being blocked."));
                        continue block53;
                    }
                    byte[] pathBytes = new byte[message.data.length - 2];
                    ByteBuffer messageBuffer = ByteBuffer.wrap(message.data);
                    short id = messageBuffer.getShort();
                    messageBuffer.get(pathBytes);
                    RestProxyService service = this.serviceFactory.getRestProxyService();
                    service.sendRequest(deviceId, id, new String(pathBytes), this);
                    continue block53;
                }
                case 96: 
                case 98: 
                case 100: 
                case 102: {
                    if (this.isDeviceBlocked(deviceId)) {
                        log.debug((Object)("Processing of tag " + message.tag + " aborted due to device " + deviceId + " being blocked."));
                        continue block53;
                    }
                    this.encryptionHelper.receivedData(deviceId, message.tag, message.sessionId, message.data);
                    continue block53;
                }
            }
            if (this.isDeviceBlocked(deviceId)) {
                log.debug((Object)("Processing of tag " + message.tag + " aborted due to device " + deviceId + " being blocked."));
                continue;
            }
            HashMap<Long, Session> hashMap = this.sessions;
            synchronized (hashMap) {
                session = this.sessions.get(message.sessionId);
            }
            if (session == null || session.sender == null) {
                log.warn((Object)"session is null!");
                continue;
            }
            session.sender.receivedData(deviceId, message.tag, message.sessionId, message.data);
        }
        return buffer.remaining() > 0 ? buffer : null;
    }

    private void handleAutomaticUnblocking(GatewayDevice device) {
        if (!this.automaticUnblockingEnabled) {
            log.debug((Object)"Automatic unblocking disabled, skipping.");
            return;
        }
        String serialNumber = device.getSerialNumber();
        if (serialNumber == null) {
            log.debug((Object)("Device " + device.mac + " has no serial number, skipping automatic unblocking."));
            return;
        }
        log.debug((Object)("Handling automatic unblocking for SN " + serialNumber + " (device " + device.mac + ")"));
        this.blockades.releaseSerialNumber(device.mac, serialNumber);
    }

    private String getSerialNumber(Message message, int pos) {
        try {
            int snLen = Utility.byteArrayToInt(message.data, pos, 1);
            return snLen > 0 ? Utility.byteArrayASCIIToString(message.data, pos + 1, snLen) : null;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.debug((Object)"Cannot extract serial number from hello packet, assumig old GC version.");
            return null;
        }
    }

    public boolean isDeviceBlocked(String deviceId) {
        return this.blockades.isBlockOngoing(deviceId);
    }

    private void scheduleEnryptionResponseMessage(String deviceId) throws InterruptedException {
        this.signingQueue.put(deviceId);
    }

    private boolean isReportedIpSupported(GatewayDevice device) {
        return device.versionMajor > 3 || device.versionMajor == 3 && device.versionMinor >= 9;
    }

    private byte[] createVerifyMessage(int major, int minor, byte[] salt) {
        byte[] msg = null;
        long version = (long)major << 32 | (long)minor;
        long versionMin = 0x200000006L;
        if (version >= versionMin) {
            msg = GatewayDeviceConnection.createMessage(2, 0L, this.signMessage(salt));
        } else {
            log.debug((Object)"to old version of client, not signing salt");
            msg = GatewayDeviceConnection.createMessage(2, 0L, salt);
        }
        return msg;
    }

    private byte[] createVerifyTlsMessage(int major, int minor, byte[] salt) {
        byte[] pk = this.getPublicKey();
        byte[] signedSalt = this.signMessage(salt);
        boolean needsCertificates = this.getCertificatesLengthForVersion(major, minor);
        int dataSize = signedSalt.length + pk.length;
        if (needsCertificates) {
            dataSize += 4 + this.encryptionHelper.getKeyCertLength() + 4 + this.encryptionHelper.getCaCertLength();
        }
        byte[] data = new byte[dataSize];
        ByteBuffer outputBuffer = ByteBuffer.wrap(data);
        outputBuffer.put(signedSalt);
        outputBuffer.put(pk);
        if (needsCertificates) {
            outputBuffer.putInt(this.encryptionHelper.getKeyCertLength());
            outputBuffer.putInt(this.encryptionHelper.getCaCertLength());
            outputBuffer.put(this.encryptionHelper.getKeyCert());
            outputBuffer.put(this.encryptionHelper.getCaCert());
        }
        return GatewayDeviceConnection.createMessage(9, 0L, data);
    }

    private byte[] createEncryptedVerifyMessage(GatewayDevice device) {
        boolean needsCertificates = this.getCertificatesLengthForVersion(device.versionMajor, device.versionMinor);
        int dataSize = 32;
        if (needsCertificates) {
            dataSize += 4 + this.encryptionHelper.getKeyCertLength() + 4 + this.encryptionHelper.getCaCertLength();
        }
        byte[] data = new byte[dataSize];
        ByteBuffer outputBuffer = ByteBuffer.wrap(data);
        byte[] reserved = new byte[32];
        outputBuffer.put(reserved);
        if (needsCertificates) {
            outputBuffer.putInt(this.encryptionHelper.getKeyCertLength());
            outputBuffer.putInt(this.encryptionHelper.getCaCertLength());
            outputBuffer.put(this.encryptionHelper.getKeyCert());
            outputBuffer.put(this.encryptionHelper.getCaCert());
        }
        byte[] message = GatewayDeviceConnection.createMessage(2, 0L, data);
        try {
            byte[] encrypted = this.encrypt(device, message);
            return GatewayDeviceConnection.createMessage(10, 0L, encrypted);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to encrypt verify message! using not encrypted one! (" + e.getMessage() + ")"));
            return message;
        }
    }

    private byte[] createEncryptionResponseMessage() {
        byte[] pk = this.getPublicKey();
        byte[] signedPk = this.signMessage(pk);
        int size = signedPk.length + pk.length;
        byte[] data = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.put(pk);
        buffer.put(signedPk);
        return GatewayDeviceConnection.createMessage(251, 0L, data);
    }

    private boolean getCertificatesLengthForVersion(int major, int minor) {
        long version = (long)major << 32 | (long)minor;
        long versionMin = 0x300000003L;
        return version >= versionMin;
    }

    private byte[] signMessage(byte[] message) {
        return this.encryptionHelper.encryption_sign_message(message);
    }

    private void checkVersionNumber(GatewayDevice device) {
        if (device.deviceType != 1) {
            log.debug((Object)("Device type is " + device.deviceType + ". Firmware will not be sent!"));
            return;
        }
        log.debug((Object)("Device type is " + device.deviceType + ". Firmware will be sent!"));
        if (this.firmwareVersion == null) {
            return;
        }
        log.debug((Object)("latest firmware version is " + this.firmwareVersion + ", GC has " + device.versionMajor + "." + device.versionMinor));
        String[] fields = this.firmwareVersion.split("\\.");
        int[] latestVersion = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            latestVersion[i] = Integer.parseInt(fields[i]);
        }
        if (latestVersion[0] > device.versionMajor || latestVersion[0] == device.versionMajor && latestVersion[1] > device.versionMinor) {
            this.forceUpgrade(device.mac);
        }
    }

    private int extractProtocolIntValue(ByteBuffer buffer, int length) {
        byte[] valueSizeArray = new byte[length];
        buffer.get(valueSizeArray);
        return (int)Utility.byteArrayToInt(valueSizeArray);
    }

    private Message extractMessage(ByteBuffer buffer, String deviceId) {
        if (buffer.remaining() == 0) {
            return null;
        }
        int originalBufferPos = buffer.position();
        try {
            Message message = new Message();
            byte cookie = buffer.get();
            if (cookie != -105) {
                log.warn((Object)"Malformed protocol packet, could not find the cookie.");
                this.restartDevice(deviceId);
                return null;
            }
            message.tag = buffer.get();
            message.length = this.extractProtocolIntValue(buffer, 2);
            message.sessionId = this.extractProtocolIntValue(buffer, 4);
            message.data = new byte[message.length];
            buffer.get(message.data);
            return message;
        }
        catch (Exception ignored) {
            log.debug((Object)"Protocol packet incomplete, will try to decode later");
            buffer.position(originalBufferPos);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDevice(String deviceId) {
        log.debug((Object)("start removeDevice(deviceId=" + deviceId + ")"));
        this.serverBackend.close(deviceId);
        GatewayDevice device = null;
        Cloneable cloneable = this.devices;
        synchronized (cloneable) {
            device = this.devices.remove(deviceId);
        }
        if (device == null) {
            cloneable = this.unverifiedDevices;
            synchronized (cloneable) {
                device = this.unverifiedDevices.remove(deviceId);
            }
            if (device != null) {
                this.notifyListenersDisconnected(device, "REMOVE_UNVERIFIED");
            } else {
                log.info((Object)"GatewayDevice disconnected was not registered!");
                return;
            }
        }
        log.info((Object)("Device disconnected: " + deviceId));
        cloneable = device.sessions;
        synchronized (cloneable) {
            for (Session session : device.sessions) {
                HashMap<Long, Session> hashMap = this.sessions;
                synchronized (hashMap) {
                    this.sessions.remove(session);
                }
            }
        }
        device.disconnect();
        cloneable = this.incomingMessagesBuffer;
        synchronized (cloneable) {
            this.incomingMessagesBuffer.remove(deviceId);
        }
    }

    @Override
    public void deviceDisconnected(String deviceId) {
        this.deviceDisconnected(deviceId, "GDCLIENT_CLOSED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceDisconnected(String deviceId, String reason) {
        log.debug((Object)("start deviceDisconnected(deviceId=" + deviceId + ")"));
        GatewayDevice device = null;
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            device = this.devices.get(deviceId);
        }
        if (device != null) {
            this.notifyListenersDisconnected(device, reason);
        }
        this.removeDevice(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processKeepAlive(String deviceId) {
        GatewayDevice device = null;
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            device = this.devices.get(deviceId);
        }
        if (device == null) {
            log.debug((Object)("// Strange, this should not happen, deviceId: " + deviceId));
            return;
        }
        device.updateAlive();
        this.notifyListenersKeepAliveReceived(deviceId);
        this.sendSimple(5, deviceId, null);
        boolean deviceCurrentlyBlocked = device.isBlocked();
        boolean blockOngoing = this.blockades.isBlockOngoing(deviceId);
        if (!deviceCurrentlyBlocked && blockOngoing) {
            device.setBlocked(true);
        } else if (deviceCurrentlyBlocked && !blockOngoing) {
            this.blockades.unblock(deviceId, false);
            this.deviceDisconnected(deviceId, "UNBLOCK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeDeadDevices(long inactivityPeriodSeconds) {
        log.debug((Object)"Purging old devices");
        long tooOldAlive = System.currentTimeMillis() - inactivityPeriodSeconds * 1000L;
        ArrayList<GatewayDevice> toDisconnect = new ArrayList<GatewayDevice>();
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            Collection<GatewayDevice> devicesList = this.devices.values();
            for (GatewayDevice device : devicesList) {
                if (device.lastAlive >= tooOldAlive) continue;
                toDisconnect.add(device);
            }
        }
        for (GatewayDevice device : toDisconnect) {
            this.deviceDisconnected(device.mac, "TIMEOUT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<GatewayDevice> getAllDevices() {
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            return new ArrayList<GatewayDevice>(this.devices.values());
        }
    }

    public void setServerBackend(ServerBackendInterface serverBackend) {
        this.serverBackend = serverBackend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartDevice(String id) {
        this.serverBackend.send(id, GatewayDeviceConnection.createMessage(6, 0L, null));
        GatewayDevice device = null;
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            device = this.devices.get(id);
        }
        if (device != null) {
            this.notifyListenersDisconnected(device, "RESTART_REQUESTED");
        }
        this.removeDevice(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpgrade(String id) {
        GatewayDevice device;
        log.debug((Object)("forcing upgrade of GC " + id));
        this.serverBackend.send(id, GatewayDeviceConnection.createMessage(7, 0L, null));
        HashMap<String, GatewayDevice> hashMap = this.devices;
        synchronized (hashMap) {
            device = this.devices.get(id);
        }
        if (device != null) {
            this.notifyListenersDisconnected(device, "UPGRADE_REQUESTED");
        }
        this.removeDevice(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(GatewayDeviceConnectionListener listener) {
        GatewayDeviceConnectionListener gatewayDeviceConnectionListener = listener;
        synchronized (gatewayDeviceConnectionListener) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(GatewayDeviceConnectionListener listener) {
        GatewayDeviceConnectionListener gatewayDeviceConnectionListener = listener;
        synchronized (gatewayDeviceConnectionListener) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersConnected(GatewayDevice device) {
        List<GatewayDeviceConnectionListener> list = this.listeners;
        synchronized (list) {
            for (GatewayDeviceConnectionListener listener : this.listeners) {
                listener.connected(device.mac, device.publicIpAddress, device.localIpAddress, device.getSerialNumber(), this.restUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersDisconnected(GatewayDevice device, String reason) {
        List<GatewayDeviceConnectionListener> list = this.listeners;
        synchronized (list) {
            for (GatewayDeviceConnectionListener listener : this.listeners) {
                listener.disconnected(device.mac, device.publicIpAddress, device.getSerialNumber(), reason, this.restUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersReceivedLogs(String mac, String logs) {
        List<GatewayDeviceConnectionListener> list = this.listeners;
        synchronized (list) {
            for (GatewayDeviceConnectionListener listener : this.listeners) {
                listener.receivedLogs(mac, logs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListenersKeepAliveReceived(String mac) {
        List<GatewayDeviceConnectionListener> list = this.listeners;
        synchronized (list) {
            for (GatewayDeviceConnectionListener listener : this.listeners) {
                listener.keepAliveReceived(mac);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GatewayDevice findBySessionId(Long sessionId) {
        Session session;
        HashMap<Long, Session> hashMap = this.sessions;
        synchronized (hashMap) {
            session = this.sessions.get(sessionId);
        }
        if (session == null) {
            return null;
        }
        GatewayDevice gatewayDevice = this.findById(session.deviceId);
        return gatewayDevice;
    }

    public boolean isConnected(String mac) {
        return this.findById(mac) != null;
    }

    public String getServerUrl(String deviceId) {
        log.trace((Object)("start getServerUrl(deviceId=" + deviceId + ")"));
        SessionEntity session = this.daoFactory.getSessionDao().get(deviceId);
        log.trace((Object)("session: " + session));
        if (session == null || this.blockades.isBlockOngoing(deviceId)) {
            log.debug((Object)("Device with mac=" + deviceId + " is not connected to cluster (no session) or is blocked. Returning null serverUrl..."));
            return null;
        }
        return session.getServerUrl();
    }

    public List<BlockedDevice> getBlockedDevices() {
        ArrayList<BlockedDevice> blockDevices = new ArrayList<BlockedDevice>();
        Map<String, Blockade> activeBlockades = this.blockades.getActiveBlockades();
        for (Map.Entry<String, Blockade> entry : activeBlockades.entrySet()) {
            GatewayDevice device = this.findById(entry.getKey());
            if (device == null) continue;
            BlockedDevice blockedDevice = new BlockedDevice();
            blockedDevice.setMac(device.getMac());
            blockedDevice.setSerialNumber(device.getSerialNumber());
            blockedDevice.setPublicIp(device.getPublicIpAddress());
            blockedDevice.setBlockCount(Integer.valueOf(entry.getValue().getBlockCount()));
            blockedDevice.setBlockDate(entry.getValue().getBlockDate());
            blockedDevice.setBlockPeriod(this.blockPeriodCache.getBlockPeriod(Integer.valueOf(entry.getValue().getBlockCount()), BlockPeriodCache.Unit.MINUTE));
            blockedDevice.setServerUrl(this.restUrl);
            blockDevices.add(blockedDevice);
        }
        return blockDevices;
    }
}

