/*
 * Decompiled with CFR 0.152.
 */
package homemonitor.Echo;

import homemonitor.GDErrorCode;
import homemonitor.GatewayDeviceConnectionInterface;
import homemonitor.SenderInterface;
import homemonitor.Utility;

public class SequentialEchoApp
implements SenderInterface {
    private GatewayDeviceConnectionInterface gatewayDeviceConnection;
    private String ip;
    private String mac;
    private String message;
    private int repetitions;
    private int currRepetition = 0;

    public SequentialEchoApp(String mac, String ip, String message, GatewayDeviceConnectionInterface gatewayDeviceConnection, int repetitions) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
        this.mac = mac;
        this.ip = ip;
        this.message = message;
        this.repetitions = repetitions;
    }

    @Override
    public void receivedData(String deviceId, int tag, long sessionId, byte[] data) {
        if (tag == 0 && data[0] == 0) {
            return;
        }
        if (tag == 0 && data[0] == 1) {
            System.out.println("Error: device sent STATUS error message.");
        } else {
            System.out.println("Received echo response for session: " + sessionId + " message: \t" + Utility.byteArrayASCIIToString(data));
        }
        this.gatewayDeviceConnection.destroySession(sessionId);
        if (++this.currRepetition < this.repetitions) {
            this.sendEchoRequest();
        }
    }

    public void sendEchoRequest() {
        long sessionId = this.gatewayDeviceConnection.createSession(this.mac, this);
        if (sessionId == 0L) {
            System.out.println("No device connected from address: " + this.ip);
            return;
        }
        GDErrorCode error = this.gatewayDeviceConnection.send(-2, sessionId, Utility.stringToByteArray(this.message));
        if (error != GDErrorCode.NoError) {
            System.out.println("Cannot send echo request to device identified by id: " + this.mac + ", with session number: " + sessionId + ". Error code: " + error.toString());
            return;
        }
        System.out.println("Message sent to device at " + this.ip + ", session number: " + sessionId);
    }

    @Override
    public void deviceDisconnected(String deviceId) {
        System.out.println("Device " + this.mac + " (deviceId: " + deviceId + ") from address " + this.ip + " is disconnected.");
    }
}

