/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.util;

import com.vestiacom.util.SharedCache;
import com.vestiacom.util.SharedCacheException;
import com.vestiacom.util.SharedCacheInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SharedCacheInfinispan
implements SharedCache {
    private EmbeddedCacheManager cacheManager;

    @Autowired
    @Required
    public void setEmbeddedCacheManager(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public <K, V> ConcurrentMap<K, V> getMap(String cacheName, SharedCache.Flag ... flags) {
        if (ArrayUtils.contains((Object[])flags, (Object)((Object)SharedCache.Flag.RETURN_VALUES))) {
            return this.cacheManager.getCache(cacheName);
        }
        return this.cacheManager.getCache(cacheName).getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
    }

    @Override
    public Integer countEntries(String cacheName) {
        this.validateCacheName(cacheName);
        return this.getMap(cacheName, new SharedCache.Flag[0]).size();
    }

    private void validateCacheName(String cacheName) {
        if (StringUtils.isBlank((CharSequence)cacheName)) {
            throw new SharedCacheException(SharedCacheException.ErrorCode.NO_CACHE_NAME);
        }
        if (!this.cacheManager.getCacheNames().contains(cacheName)) {
            throw new SharedCacheException(SharedCacheException.ErrorCode.CACHE_NOT_FOUND);
        }
    }

    @Override
    public Set<Object> listKeys(String cacheName) {
        this.validateCacheName(cacheName);
        return this.getMap(cacheName, new SharedCache.Flag[0]).keySet();
    }

    @Override
    public SharedCacheInfo getInfo() {
        SharedCacheInfo info = new SharedCacheInfo();
        info.setClusterName(this.cacheManager.getClusterName());
        info.setAddress(this.cacheManager.getAddress().toString());
        info.setAddresses(this.getAddresses());
        info.setPhysicalAddresses(this.getPhysicalAddresses());
        info.setCoordinatorAddress(this.cacheManager.getCoordinator().toString());
        info.setCoordinator(this.cacheManager.isCoordinator());
        info.setCacheNames(this.cacheManager.getCacheNames());
        return info;
    }

    private List<String> getAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Address address : this.cacheManager.getMembers()) {
            addresses.add(address.toString());
        }
        return addresses;
    }

    private List<String> getPhysicalAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        for (Address address : this.cacheManager.getTransport().getPhysicalAddresses()) {
            addresses.add(address.toString());
        }
        return addresses;
    }
}

