/*
 * Decompiled with CFR 0.152.
 */
package com.vestiacom.gdserver.util;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class MailGate {
    private static Logger log = Logger.getLogger(MailGate.class);
    @Value(value="${mail.host:localhost}")
    private String host;
    @Value(value="${mail.from:team@remote-nas.com}")
    private String from;
    @Value(value="${mail.worker.sleep[ms]:10000}")
    private long workerSleepTime;
    @Value(value="${mail.worker.try.count:3}")
    private int tryCount;
    private ThreadPoolTaskExecutor taskExecutor;
    private PriorityBlockingQueue<Message> queue = new PriorityBlockingQueue();
    private boolean isRunning = true;

    @Autowired
    @Required
    public void setTaskExecutor(ThreadPoolTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @PostConstruct
    public void initialize() {
        this.taskExecutor.execute(new Runnable(){

            private String getName() {
                return MailGate.class.getSimpleName() + "." + this.getClass().getSimpleName();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                log.debug((Object)("Starting " + this.getName()));
                try {
                    while (MailGate.this.isRunning) {
                        try {
                            Message message = (Message)MailGate.this.queue.take();
                            boolean sent = MailGate.this.doSend(message);
                            if (!sent) {
                                if (message.failures++ < MailGate.this.tryCount) {
                                    MailGate.this.queue.add(message);
                                    log.debug((Object)("Will try to send message " + message + " later"));
                                } else {
                                    log.warn((Object)("Message " + message + " rejected"));
                                }
                            }
                            Thread.sleep(MailGate.this.workerSleepTime);
                        }
                        catch (InterruptedException e) {
                        }
                        catch (Throwable e) {
                            log.warn((Object)("Error trying to send mail notification: " + e.getMessage()));
                        }
                    }
                }
                finally {
                    log.debug((Object)("Stopped " + this.getName()));
                }
            }
        });
    }

    @PreDestroy
    private void shutdown() {
        this.isRunning = false;
    }

    public void send(Message ... messages) {
        this.send(Arrays.asList(messages));
    }

    public void send(List<Message> messages) {
        this.queue.addAll(messages);
    }

    public boolean sendSynchronously(Message message) {
        return this.doSend(message);
    }

    private boolean doSend(Message message) {
        try {
            log.info((Object)("Sending message " + message));
            JavaMailSenderImpl sender = new JavaMailSenderImpl();
            sender.setHost(this.host);
            MimeMessage msg = sender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(msg, message.isMultipart());
            helper.setFrom(this.from);
            this.addRecipients(helper, message);
            helper.setSubject(message.getSubject());
            helper.setText(message.getText(), message.isHtml());
            this.addAttachments(helper, message);
            sender.send(msg);
            log.info((Object)"Sent message successfully....");
            return true;
        }
        catch (MessagingException ex) {
            log.warn((Object)String.format("Failed to send message %s, error is %s.", message, ex.getMessage()));
            return false;
        }
    }

    private void addRecipients(MimeMessageHelper helper, Message message) throws MessagingException {
        for (Map.Entry<Message.RecipientType, List<String>> entry : message.getRecipients().entrySet()) {
            for (String recipient : entry.getValue()) {
                this.addRecipient(helper, entry.getKey(), recipient);
            }
        }
    }

    private void addRecipient(MimeMessageHelper helper, Message.RecipientType recipientType, String recipient) throws MessagingException {
        if (recipientType == Message.RecipientType.CC) {
            helper.addCc(this.address(recipient));
        } else if (recipientType == Message.RecipientType.BCC) {
            helper.addBcc(this.address(recipient));
        } else {
            helper.addTo(this.address(recipient));
        }
    }

    private InternetAddress address(String emailAddress) throws AddressException {
        String email;
        String personal = "";
        int ltIndex = emailAddress.lastIndexOf(60);
        if (ltIndex == -1) {
            email = emailAddress;
        } else {
            int gtIndex = emailAddress.lastIndexOf(62);
            if (gtIndex == -1 || gtIndex < ltIndex) {
                throw new AddressException("invalid email address " + emailAddress);
            }
            personal = emailAddress.substring(0, ltIndex).trim();
            email = emailAddress.substring(ltIndex + 1, gtIndex);
        }
        try {
            return new InternetAddress(email, personal, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void addAttachments(MimeMessageHelper helper, Message message) throws MessagingException {
        if (!message.getAttachments().isEmpty()) {
            for (Message.Attachment attachment : message.getAttachments()) {
                helper.addAttachment(attachment.getName(), attachment.getContent());
            }
        }
    }

    public static class Message
    implements Comparable<Message> {
        private String subject;
        private String from;
        private String text;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private Map<Message.RecipientType, List<String>> recipients = new HashMap<Message.RecipientType, List<String>>();
        private boolean html = false;
        private boolean urgent = true;
        private int failures;

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public List<Attachment> getAttachments() {
            return new ArrayList<Attachment>(this.attachments);
        }

        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        public void addAttachment(Attachment attachment) {
            this.attachments.add(attachment);
        }

        public void setRecipients(Map<Message.RecipientType, List<String>> recipients) {
            this.recipients = recipients;
        }

        public Map<Message.RecipientType, List<String>> getRecipients() {
            return new HashMap<Message.RecipientType, List<String>>(this.recipients);
        }

        public boolean isMultipart() {
            return this.html || !this.attachments.isEmpty();
        }

        public void addRecipient(Message.RecipientType recipientType, String address) {
            List<String> addresses = this.recipients.get(recipientType);
            if (addresses == null) {
                addresses = new ArrayList<String>();
                this.recipients.put(recipientType, addresses);
            }
            addresses.add(address);
        }

        public boolean isHtml() {
            return this.html;
        }

        public void setHtml(boolean html) {
            this.html = html;
        }

        public boolean isUrgent() {
            return this.urgent;
        }

        public void setUrgent(boolean urgent) {
            this.urgent = urgent;
        }

        @Override
        public int compareTo(Message o) {
            return -Boolean.valueOf(this.urgent).compareTo(o.urgent);
        }

        public String toString() {
            return MessageFormat.format("from {0}, to {1}, subject {2}", this.from != null ? this.from : "[system]", this.recipients, this.subject);
        }

        public static class Attachment {
            private String name;
            private DataSource content;

            public Attachment() {
            }

            public Attachment(String name, DataSource content) {
                this.name = name;
                this.content = content;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public DataSource getContent() {
                return this.content;
            }

            public void setContent(DataSource content) {
                this.content = content;
            }
        }
    }
}

